/*
 * Decompiled with CFR 0.152.
 */
package com.ethanshea.arbor;

import com.ethanshea.arbor.Generator;
import com.ethanshea.arbor.Paramiter;
import com.ethanshea.arbor.ParamiterManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Collection;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchedGenerator
extends Generator {
    ParamiterManager params = new ParamiterManager();
    float branchSpeed;

    public BranchedGenerator() {
        this.params.addParamiter("Starting Size", Paramiter.Type.FLOAT, Float.valueOf(20.0f), 0, 50);
        this.params.addParamiter("Max Levels", Paramiter.Type.INT, 80, 1, 100);
        this.params.addParamiter("Branch Chance", Paramiter.Type.FLOAT, Float.valueOf(10.0f), 0, 50);
        this.params.addParamiter("Branch Chance Decay", Paramiter.Type.FLOAT, Float.valueOf(60.0f), 0, 100);
        this.params.addParamiter("Fork Chance", Paramiter.Type.FLOAT, Float.valueOf(10.0f), 0, 50);
        this.params.addParamiter("Fork Chance Decay", Paramiter.Type.FLOAT, Float.valueOf(60.0f), 0, 100);
        this.params.addParamiter("Split Angle", Paramiter.Type.FLOAT, Float.valueOf(30.0f), 0, 90);
        this.params.addParamiter("Split Angle Stiffness", Paramiter.Type.FLOAT, Float.valueOf(0.2f), 0, 2);
        this.params.addParamiter("Angle Variance", Paramiter.Type.FLOAT, Float.valueOf(10.0f), 0, 45);
        this.params.addParamiter("Size Decay", Paramiter.Type.FLOAT, Float.valueOf(65.0f), 0, 150);
        this.params.addParamiter("Size Variance", Paramiter.Type.FLOAT, Float.valueOf(25.0f), 0, 50);
        this.params.addParamiter("Thickness", Paramiter.Type.FLOAT, Float.valueOf(4.0f), 0, 10);
        this.params.addParamiter("Thickness Decay", Paramiter.Type.FLOAT, Float.valueOf(95.0f), 90, 100);
        this.params.addParamiter("Branch Thickness", Paramiter.Type.FLOAT, Float.valueOf(80.0f), 0, 100);
        this.params.addParamiter("Fork Thickness", Paramiter.Type.FLOAT, Float.valueOf(60.0f), 0, 100);
    }

    @Override
    public Collection<Paramiter> getParamiters() {
        return this.params.getParamiters();
    }

    @Override
    public void redraw(Graphics g, long seed, int width, int height) {
        Graphics2D g2 = (Graphics2D)g;
        g.setColor(new Color(128, 70, 27));
        g.setColor(new Color(255, 255, 255));
        this.drawLimb(g2, new Random(seed), 0, width / 2, height * 19 / 20, 90.0f, this.params.getFloat("Starting Size"), this.params.getFloat("Thickness"), this.params.getFloat("Branch Chance") / 100.0f, this.params.getFloat("Fork Chance") / 100.0f);
    }

    public void drawLimb(Graphics2D g, Random rad, int level, float x, float y, float angle, float size, float thickness, float branchChance, float forkChance) {
        if (level >= this.params.getInt("Max Levels")) {
            return;
        }
        float endX = (float)((double)x + Math.cos((double)angle * Math.PI / 180.0) * (double)size);
        float endY = (float)((double)y - Math.sin((double)angle * Math.PI / 180.0) * (double)size);
        float angleOffset = 0.0f;
        float newThickness = 1.0f;
        float rand = rad.nextFloat();
        if (rand < branchChance) {
            angleOffset = this.genRandomSignedPow(rad, this.params.getFloat("Split Angle Stiffness")) * this.params.getFloat("Split Angle");
            this.drawLimb(g, rad, level + 1, endX, endY, angle + angleOffset + this.genRandomSigned(rad) * this.params.getFloat("Angle Variance"), size * ((this.params.getFloat("Size Decay") + this.genRandomSigned(rad) * this.params.getFloat("Size Variance")) / 100.0f), Math.max(0.0f, thickness * this.params.getFloat("Branch Thickness") * this.params.getFloat("Thickness Decay") / 10000.0f), branchChance * this.params.getFloat("Branch Chance Decay") / 100.0f, forkChance);
            angleOffset = 0.0f;
        } else if (rand < branchChance + forkChance) {
            angleOffset = this.genRandomSignedPow(rad, this.params.getFloat("Split Angle Stiffness")) * this.params.getFloat("Split Angle");
            newThickness = this.params.getFloat("Fork Thickness") / 100.0f;
            this.drawLimb(g, rad, level + 1, endX, endY, angle - angleOffset + this.genRandomSigned(rad) * this.params.getFloat("Angle Variance"), size * ((this.params.getFloat("Size Decay") + this.genRandomSigned(rad) * this.params.getFloat("Size Variance")) / 100.0f), Math.max(0.0f, thickness * newThickness * this.params.getFloat("Thickness Decay") / 100.0f), branchChance, this.params.getFloat("Fork Chance Decay") / 100.0f * forkChance);
        }
        this.drawLimb(g, rad, level + 1, endX, endY, angleOffset + angle + this.genRandomSigned(rad) * this.params.getFloat("Angle Variance"), size * ((this.params.getFloat("Size Decay") + this.genRandomSigned(rad) * this.params.getFloat("Size Variance")) / 100.0f), Math.max(0.0f, thickness * newThickness * this.params.getFloat("Thickness Decay") / 100.0f), branchChance, forkChance);
        if (size > 0.5f) {
            g.setStroke(new BasicStroke(thickness));
            g.drawLine((int)x, (int)y, (int)endX, (int)endY);
        }
    }

    @Override
    public String toString() {
        return "Branched";
    }

    public float genRandomSigned(Random rad) {
        if (rad.nextBoolean()) {
            return -rad.nextFloat();
        }
        return rad.nextFloat();
    }

    private float genRandomSignedPow(Random rad, float pow) {
        if (rad.nextBoolean()) {
            return (float)(-Math.pow(rad.nextFloat(), pow));
        }
        return (float)Math.pow(rad.nextFloat(), pow);
    }

    @Override
    public float getEstimatedDrawTime() {
        return 0.0f;
    }
}

