/*
 * Decompiled with CFR 0.152.
 */
package com.ethanshea.arbor;

import com.ethanshea.arbor.ColorIcon;
import com.ethanshea.arbor.DrawPanel;
import com.ethanshea.arbor.Generator;
import com.ethanshea.arbor.Paramiter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Random;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ControlPanel
extends JPanel {
    private static final long serialVersionUID = -986222644453098218L;
    private static float FLOAT_PRECISION = 100.0f;
    private JComboBox generator;
    private JSpinner seed;
    private JPanel paramiters;
    private JButton redraw;
    private DrawPanel draw;
    private Generator selected;
    private HashMap<Paramiter, JComponent> componentMapping;
    private boolean blockRedraw = false;

    public ControlPanel(final DrawPanel draw, Generator ... generators) {
        this.draw = draw;
        this.componentMapping = new HashMap();
        this.selected = generators[0];
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(200, 500));
        JPanel north = new JPanel();
        north.setLayout(new BoxLayout(north, 1));
        JPanel seedPanel = new JPanel(new BorderLayout());
        this.seed = new JSpinner();
        this.seed.setValue(1);
        this.seed.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                draw.setSeed(((Integer)ControlPanel.this.seed.getValue()).intValue());
                ControlPanel.this.sendRedraw();
            }
        });
        seedPanel.add(this.seed);
        JButton newSeed = new JButton("New");
        newSeed.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Random rad = new Random();
                int numSeed = rad.nextInt();
                ControlPanel.this.seed.setValue(numSeed);
                draw.setSeed(numSeed);
                ControlPanel.this.sendRedraw();
            }
        });
        seedPanel.add((Component)newSeed, "East");
        JLabel seedLabel = new JLabel("Seed: ");
        seedLabel.setLabelFor(this.seed);
        seedPanel.add((Component)seedLabel, "West");
        north.add(seedPanel);
        this.generator = new JComboBox<Generator>(generators);
        this.generator.setEditable(false);
        draw.setGenerator(this.selected);
        this.generator.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                ControlPanel.this.selected = (Generator)ie.getItem();
                ControlPanel.this.resetParamiterList();
                draw.setGenerator(ControlPanel.this.selected);
                ControlPanel.this.sendRedraw();
            }
        });
        north.add(this.generator);
        this.add((Component)north, "North");
        this.paramiters = new JPanel();
        this.paramiters.setLayout(new BoxLayout(this.paramiters, 1));
        JScrollPane para = new JScrollPane(this.paramiters);
        para.setHorizontalScrollBarPolicy(31);
        para.setVerticalScrollBarPolicy(20);
        this.add(para);
        this.resetParamiterList();
        JPanel south = new JPanel();
        south.setLayout(new GridLayout(2, 1));
        this.redraw = new JButton("Redraw");
        this.redraw.setEnabled(false);
        this.redraw.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                draw.repaint();
            }
        });
        south.add(this.redraw);
        JButton randomize = new JButton("Randomize");
        randomize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                System.out.println("Randomize!");
                ControlPanel.this.blockRedraw = true;
                for (Paramiter p : ControlPanel.this.componentMapping.keySet()) {
                    p.randomize();
                    switch (p.getType()) {
                        case INT: {
                            ((JSlider)ControlPanel.this.componentMapping.get(p)).setValue((Integer)p.getValue());
                            break;
                        }
                        case FLOAT: {
                            ((JSlider)ControlPanel.this.componentMapping.get(p)).setValue((int)(((Float)p.getValue()).floatValue() * FLOAT_PRECISION));
                            break;
                        }
                        case BOOLEAN: {
                            ((JCheckBox)ControlPanel.this.componentMapping.get(p)).setSelected((Boolean)p.getValue());
                            break;
                        }
                        case COLOR: {
                            ((JButton)ControlPanel.this.componentMapping.get(p)).setIcon(new ColorIcon((Color)p.getValue()));
                        }
                    }
                }
                ControlPanel.this.blockRedraw = false;
                ControlPanel.this.sendRedraw();
            }
        });
        south.add(randomize);
        this.add((Component)south, "South");
    }

    public void resetParamiterList() {
        this.paramiters.removeAll();
        this.componentMapping.clear();
        for (final Paramiter p : this.selected.getParamiters()) {
            if (p.getType().hasLabel()) {
                final JLabel label = new JLabel(p.getName());
                label.setName(p.getName());
                label.setAlignmentX(0.0f);
                this.paramiters.add(label);
                switch (p.getType()) {
                    case INT: {
                        final JSlider slider = new JSlider(Float.valueOf(p.getMin()).intValue(), Float.valueOf(p.getMax()).intValue(), (Integer)p.getValue());
                        slider.setSnapToTicks(true);
                        slider.setPreferredSize(new Dimension(50, 16));
                        label.setText(String.valueOf(label.getText()) + ": " + p.getValue());
                        slider.addChangeListener(new ChangeListener(){

                            public void stateChanged(ChangeEvent e) {
                                label.setText(String.valueOf(label.getName()) + ": " + slider.getValue());
                                p.setValue(slider.getValue());
                                ControlPanel.this.sendRedraw();
                            }
                        });
                        this.paramiters.add(slider);
                        this.componentMapping.put(p, slider);
                        break;
                    }
                    case FLOAT: {
                        final JSlider floatSlider = new JSlider((int)(p.getMin() * FLOAT_PRECISION), (int)(p.getMax() * FLOAT_PRECISION), (int)(((Float)p.getValue()).floatValue() * FLOAT_PRECISION));
                        label.setText(String.valueOf(label.getText()) + ": " + p.getValue());
                        floatSlider.setPreferredSize(new Dimension(50, 16));
                        floatSlider.addChangeListener(new ChangeListener(){

                            public void stateChanged(ChangeEvent e) {
                                label.setText(String.valueOf(label.getName()) + ": " + (float)floatSlider.getValue() / FLOAT_PRECISION);
                                p.setValue(new Float((float)floatSlider.getValue() / FLOAT_PRECISION));
                                ControlPanel.this.sendRedraw();
                            }
                        });
                        this.paramiters.add(floatSlider);
                        this.componentMapping.put(p, floatSlider);
                        break;
                    }
                    case STRING: {
                        label.setText(String.valueOf(label.getText()) + ":");
                        JTextField text = new JTextField((String)p.getValue());
                        this.paramiters.add(text);
                    }
                }
                continue;
            }
            switch (p.getType()) {
                case BOOLEAN: {
                    final JCheckBox box = new JCheckBox(p.getName(), (boolean)((Boolean)p.getValue()));
                    box.addChangeListener(new ChangeListener(){

                        public void stateChanged(ChangeEvent e) {
                            p.setValue(box.isSelected());
                            ControlPanel.this.sendRedraw();
                        }
                    });
                    this.paramiters.add(box);
                    this.componentMapping.put(p, box);
                    break;
                }
                case COLOR: {
                    final ColorIcon icon = new ColorIcon();
                    icon.setColor((Color)p.getValue());
                    final JButton color = new JButton(p.getName(), icon);
                    color.setHorizontalTextPosition(10);
                    color.setIconTextGap(10);
                    color.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            Color newColor = JColorChooser.showDialog(null, p.getName(), icon.getColor());
                            if (newColor != null) {
                                color.setIcon(new ColorIcon(newColor));
                                p.setValue(newColor);
                                ControlPanel.this.sendRedraw();
                            }
                        }
                    });
                    this.paramiters.add(color);
                    this.componentMapping.put(p, color);
                }
            }
        }
    }

    public Generator getSelected() {
        return this.selected;
    }

    public void sendRedraw() {
        if (this.blockRedraw) {
            return;
        }
        if (this.selected.getEstimatedDrawTime() < 0.2f) {
            this.draw.repaint();
            this.redraw.setEnabled(false);
            this.redraw.setText("Redraw");
        } else {
            this.redraw.setEnabled(true);
            this.redraw.setText(String.format("Redraw: (%.2fs)", Float.valueOf(this.selected.getEstimatedDrawTime())));
        }
    }
}

