/*
 * Decompiled with CFR 0.152.
 */
package com.ethanshea.arbor;

import com.ethanshea.arbor.Generator;
import com.ethanshea.arbor.Paramiter;
import com.ethanshea.arbor.ParamiterManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Collection;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FractalGenerator
extends Generator {
    private ParamiterManager params = new ParamiterManager();
    private double branchSpeed;

    public FractalGenerator() {
        this.params.addParamiter("Background Color", Paramiter.Type.COLOR, Color.black);
        this.params.addParamiter("Start Color", Paramiter.Type.COLOR, Color.white);
        this.params.addParamiter("End Color", Paramiter.Type.COLOR, Color.DARK_GRAY);
        this.params.addParamiter("Size", Paramiter.Type.FLOAT, Float.valueOf(100.0f), 0, 200);
        this.params.addParamiter("Levels", Paramiter.Type.INT, 5, 2, 12);
        this.params.addParamiter("Branches", Paramiter.Type.INT, 10, 1, 15);
        this.params.addParamiter("Angle Variance", Paramiter.Type.FLOAT, Float.valueOf(50.0f), 0, 135);
        this.params.addParamiter("Stiffness", Paramiter.Type.FLOAT, Float.valueOf(1.0f), 0, 10);
        this.params.addParamiter("Size Decay", Paramiter.Type.FLOAT, Float.valueOf(65.0f), 0, 150);
        this.params.addParamiter("Size Decay Variance", Paramiter.Type.FLOAT, Float.valueOf(25.0f), 0, 50);
        this.params.addParamiter("Thickness", Paramiter.Type.FLOAT, Float.valueOf(4.0f), 0, 10);
        this.params.addParamiter("Thickness Decay", Paramiter.Type.FLOAT, Float.valueOf(50.0f), 0, 150);
    }

    @Override
    public Collection<Paramiter> getParamiters() {
        return this.params.getParamiters();
    }

    @Override
    public void redraw(Graphics g, long seed, int width, int height) {
        Graphics2D g2 = (Graphics2D)g;
        Color[] colors = new Color[this.params.getInt("Levels")];
        int i = 0;
        while (i < this.params.getInt("Levels")) {
            colors[i] = this.lerpColor((Color)this.params.getObject("Start Color"), (Color)this.params.getObject("End Color"), (float)i / ((float)this.params.getInt("Levels") - 1.0f));
            ++i;
        }
        long startTime = System.nanoTime();
        g2.setColor((Color)this.params.getObject("Background Color"));
        g2.setBackground(null);
        g2.fillRect(0, 0, width, height);
        g2.setColor(colors[0]);
        g2.setStroke(new BasicStroke(this.params.getFloat("Thickness")));
        this.drawLimb(g2, new Random(seed), colors, 0, width / 2, height * 19 / 20, 90.0f, this.params.getFloat("Size"), this.params.getFloat("Thickness"));
        long endTime = System.nanoTime();
        this.branchSpeed = (double)((endTime - startTime) / (long)this.getNumBranches(this.params.getInt("Levels"), this.params.getInt("Branches"))) * 1.0E-9;
    }

    public void drawLimb(Graphics2D g, Random rad, Color[] colors, int level, double x, double y, float angle, float size, float thickness) {
        double endX = x + Math.cos((double)angle * Math.PI / 180.0) * (double)size;
        double endY = y - Math.sin((double)angle * Math.PI / 180.0) * (double)size;
        g.drawLine((int)x, (int)y, (int)endX, (int)endY);
        if (level < this.params.getInt("Levels") - 1) {
            float newThickness = Math.max(0.0f, thickness * this.params.getFloat("Thickness Decay") / 100.0f);
            int i = 0;
            while (i < this.params.getInt("Branches")) {
                if (level != this.params.getInt("Levels")) {
                    g.setColor(colors[level + 1]);
                    g.setStroke(new BasicStroke(newThickness));
                }
                this.drawLimb(g, rad, colors, level + 1, endX, endY, angle + this.genRandomSignedPow(rad, this.params.getFloat("Stiffness")) * this.params.getFloat("Angle Variance"), size * ((this.params.getFloat("Size Decay") + this.genRandomSigned(rad) * this.params.getFloat("Size Decay Variance")) / 100.0f), Math.max(0.0f, thickness * this.params.getFloat("Thickness Decay") / 100.0f));
                ++i;
            }
        }
    }

    @Override
    public String toString() {
        return "Fractal";
    }

    private float genRandomSigned(Random rad) {
        if (rad.nextBoolean()) {
            return -rad.nextFloat();
        }
        return rad.nextFloat();
    }

    private float genRandomSignedPow(Random rad, float pow) {
        if (rad.nextBoolean()) {
            return (float)(-Math.pow(rad.nextFloat(), pow));
        }
        return (float)Math.pow(rad.nextFloat(), pow);
    }

    private Color lerpColor(Color a, Color b, float precent) {
        return new Color((int)((float)a.getRed() + (float)(b.getRed() - a.getRed()) * precent), (int)((float)a.getGreen() + (float)(b.getGreen() - a.getGreen()) * precent), (int)((float)a.getBlue() + (float)(b.getBlue() - a.getBlue()) * precent));
    }

    @Override
    public float getEstimatedDrawTime() {
        return (float)(this.branchSpeed * (double)this.getNumBranches(this.params.getInt("Levels"), this.params.getInt("Branches")));
    }

    private int getNumBranches(int levels, int branches) {
        int answer = 0;
        int i = 0;
        while (i < levels) {
            answer = (int)((double)answer + Math.pow(branches, i));
            ++i;
        }
        return answer;
    }
}

