/*
 * Decompiled with CFR 0.152.
 */
package com.ethanshea.arbor;

import com.ethanshea.arbor.Generator;
import com.ethanshea.arbor.Paramiter;
import com.ethanshea.arbor.ParamiterManager;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionGenerator
extends Generator {
    private ParamiterManager params = new ParamiterManager();
    private float lastXScale = 50.0f;
    private float lastYScale = 50.0f;

    public FunctionGenerator() {
        this.params.addParamiter("x scale", Paramiter.Type.FLOAT, Float.valueOf(10.0f), 1, 50);
        this.params.addParamiter("y scale", Paramiter.Type.FLOAT, Float.valueOf(10.0f), 1, 50);
        this.params.addParamiter("x^0", Paramiter.Type.FLOAT, Float.valueOf(0.0f), -10, 10);
        this.params.addParamiter("x^1", Paramiter.Type.FLOAT, Float.valueOf(0.0f), -10, 10);
        this.params.addParamiter("x^2", Paramiter.Type.FLOAT, Float.valueOf(0.0f), -10, 10);
        this.params.addParamiter("x^3", Paramiter.Type.FLOAT, Float.valueOf(0.0f), -10, 10);
        this.params.addParamiter("x^4", Paramiter.Type.FLOAT, Float.valueOf(0.0f), -10, 10);
        this.params.addParamiter("x^5", Paramiter.Type.FLOAT, Float.valueOf(0.0f), -10, 10);
    }

    @Override
    public Collection<Paramiter> getParamiters() {
        return this.params.getParamiters();
    }

    @Override
    public void redraw(Graphics g, long seed, int width, int height) {
        g.setColor(Color.RED);
        int midHeight = height / 2;
        int midWidth = width / 2;
        g.drawLine(0, midHeight, width, midHeight);
        g.drawLine(midWidth, 0, midWidth, height);
        float unitPerPixelX = this.params.getFloat("x scale") / (float)midWidth;
        float unitPerPixelY = (float)midHeight / -this.params.getFloat("y scale");
        int xMultiplier = 1;
        if (this.params.getFloat("x scale") > 50.0f) {
            xMultiplier = 10;
        }
        float x = 0.0f;
        while (x < (float)midWidth) {
            g.drawLine(midWidth + (int)x, midHeight - 1, midWidth + (int)x, midHeight + 1);
            g.drawLine(midWidth + (int)(-x), midHeight - 1, midWidth + (int)(-x), midHeight + 1);
            x += (float)(xMultiplier * midWidth) / this.params.getFloat("x scale");
        }
        g.drawString("" + (int)this.params.getFloat("x scale"), width - 25, midHeight + 2);
        int yMultiplier = 1;
        if (this.params.getFloat("y scale") > 50.0f) {
            yMultiplier = 10;
        }
        float y = 0.0f;
        while (y < (float)midHeight) {
            g.drawLine(midWidth - 1, midHeight + (int)y, midWidth + 1, midHeight + (int)y);
            g.drawLine(midWidth - 1, midHeight + (int)(-y), midWidth + 1, midHeight + (int)(-y));
            y += (float)(yMultiplier * 250) / this.params.getFloat("y scale");
        }
        g.drawString("" + (int)this.params.getFloat("y scale"), midWidth + 2, 10);
        g.setColor(Color.BLUE);
        int prevX = -midWidth - 1;
        double prevY = 0.0;
        int px = -midWidth;
        while (px < midWidth) {
            float gx = (float)px * unitPerPixelX;
            double gy = Math.pow(gx, 5.0) * (double)this.params.getFloat("x^5") + Math.pow(gx, 4.0) * (double)this.params.getFloat("x^4") + Math.pow(gx, 3.0) * (double)this.params.getFloat("x^3") + Math.pow(gx, 2.0) * (double)this.params.getFloat("x^2") + (double)(gx * this.params.getFloat("x^1")) + (double)this.params.getFloat("x^0");
            g.drawLine(px + midWidth, (int)((double)unitPerPixelY * gy) + midHeight, prevX + midWidth, (int)((double)unitPerPixelY * prevY) + midHeight);
            prevX = px++;
            prevY = gy;
        }
    }

    @Override
    public String toString() {
        return "Function";
    }

    @Override
    public float getEstimatedDrawTime() {
        return 0.0f;
    }
}

