/*
 * Decompiled with CFR 0.152.
 */
package box2dLight;

import box2dLight.PositionalLight;
import box2dLight.RayHandler;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;

public class ConeLight
extends PositionalLight {
    float coneDegree;

    public ConeLight(RayHandler rayHandler, int rays, Color color, float distance, float x, float y, float directionDegree, float coneDegree) {
        super(rayHandler, rays, color, distance, x, y, directionDegree);
        this.setConeDegree(coneDegree);
        this.setDirection(this.direction);
        this.update();
    }

    @Override
    public void setDirection(float direction) {
        this.direction = direction;
        for (int i = 0; i < this.rayNum; ++i) {
            float angle = direction + this.coneDegree - 2.0f * this.coneDegree * (float)i / ((float)this.rayNum - 1.0f);
            float s = this.sin[i] = MathUtils.sinDeg(angle);
            float c = this.cos[i] = MathUtils.cosDeg(angle);
            this.endX[i] = this.distance * c;
            this.endY[i] = this.distance * s;
        }
        if (this.staticLight) {
            this.staticUpdate();
        }
    }

    public final float getConeDegree() {
        return this.coneDegree;
    }

    public final void setConeDegree(float coneDegree) {
        if (coneDegree < 0.0f) {
            coneDegree = 0.0f;
        }
        if (coneDegree > 180.0f) {
            coneDegree = 180.0f;
        }
        this.coneDegree = coneDegree;
        this.setDirection(this.direction);
    }

    @Override
    public void setDistance(float dist) {
        this.distance = (dist *= RayHandler.gammaCorrectionParameter) < 0.01f ? 0.01f : dist;
        this.setDirection(this.direction);
    }
}

