/*
 * Decompiled with CFR 0.152.
 */
package box2dLight;

import box2dLight.RayHandler;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.Filter;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.RayCastCallback;

public abstract class Light {
    static final Color DefaultColor = new Color(0.75f, 0.75f, 0.5f, 0.75f);
    private boolean active = true;
    protected boolean soft = true;
    protected boolean xray = false;
    protected boolean staticLight = false;
    protected float softShadowLength = 2.5f;
    protected RayHandler rayHandler;
    protected boolean culled = false;
    protected int rayNum;
    protected int vertexNum;
    protected float distance;
    protected float direction;
    protected Color color = new Color();
    protected Mesh lightMesh;
    protected Mesh softShadowMesh;
    protected float colorF;
    static final int MIN_RAYS = 3;
    float[] segments;
    float[] mx;
    float[] my;
    float[] f;
    int m_index = 0;
    final Vector2 tmpPosition = new Vector2();
    static final float zero = Color.toFloatBits(0.0f, 0.0f, 0.0f, 0.0f);
    final RayCastCallback ray = new RayCastCallback(){

        @Override
        public final float reportRayFixture(Fixture fixture, Vector2 point, Vector2 normal, float fraction) {
            if (filterA != null && !Light.this.contactFilter(fixture)) {
                return -1.0f;
            }
            Light.this.mx[Light.this.m_index] = point.x;
            Light.this.my[Light.this.m_index] = point.y;
            Light.this.f[Light.this.m_index] = fraction;
            return fraction;
        }
    };
    private static Filter filterA = null;

    public Light(RayHandler rayHandler, int rays, Color color, float directionDegree, float distance) {
        rayHandler.lightList.add(this);
        this.rayHandler = rayHandler;
        this.setRayNum(rays);
        this.direction = directionDegree;
        this.distance = distance < 0.01f ? 0.01f : (distance *= RayHandler.gammaCorrectionParameter);
        this.setColor(color);
    }

    public void setColor(Color newColor) {
        if (newColor != null) {
            this.color.set(newColor);
            this.colorF = this.color.toFloatBits();
        } else {
            this.color = DefaultColor;
            this.colorF = DefaultColor.toFloatBits();
        }
        if (this.staticLight) {
            this.staticUpdate();
        }
    }

    public void setColor(float r, float g, float b, float a) {
        this.color.r = r;
        this.color.g = g;
        this.color.b = b;
        this.color.a = a;
        this.colorF = this.color.toFloatBits();
        if (this.staticLight) {
            this.staticUpdate();
        }
    }

    public void setDistance(float dist) {
    }

    abstract void update();

    abstract void render();

    public abstract void setDirection(float var1);

    public void remove() {
        this.rayHandler.lightList.removeValue(this, false);
        this.lightMesh.dispose();
        this.softShadowMesh.dispose();
    }

    public abstract void attachToBody(Body var1, float var2, float var3);

    public abstract Body getBody();

    public abstract void setPosition(float var1, float var2);

    public abstract void setPosition(Vector2 var1);

    public Vector2 getPosition() {
        return this.tmpPosition;
    }

    public abstract float getX();

    public abstract float getY();

    void staticUpdate() {
        boolean tmp = this.rayHandler.culling;
        this.staticLight = !this.staticLight;
        this.rayHandler.culling = false;
        this.update();
        this.rayHandler.culling = tmp;
        this.staticLight = !this.staticLight;
    }

    public final boolean isActive() {
        return this.active;
    }

    public final void setActive(boolean active) {
        if (active == this.active) {
            return;
        }
        if (active) {
            this.rayHandler.lightList.add(this);
            this.rayHandler.disabledLights.removeValue(this, true);
        } else {
            this.rayHandler.disabledLights.add(this);
            this.rayHandler.lightList.removeValue(this, true);
        }
        this.active = active;
    }

    public final boolean isXray() {
        return this.xray;
    }

    public final void setXray(boolean xray) {
        this.xray = xray;
        if (this.staticLight) {
            this.staticUpdate();
        }
    }

    public final boolean isStaticLight() {
        return this.staticLight;
    }

    public final void setStaticLight(boolean staticLight) {
        this.staticLight = staticLight;
        if (staticLight) {
            this.staticUpdate();
        }
    }

    public final boolean isSoft() {
        return this.soft;
    }

    public final void setSoft(boolean soft) {
        this.soft = soft;
        if (this.staticLight) {
            this.staticUpdate();
        }
    }

    public final float getSoftShadowLength() {
        return this.softShadowLength;
    }

    public final void setSoftnessLength(float softShadowLength) {
        this.softShadowLength = softShadowLength;
        if (this.staticLight) {
            this.staticUpdate();
        }
    }

    private final void setRayNum(int rays) {
        if (rays < 3) {
            rays = 3;
        }
        this.rayNum = rays;
        this.vertexNum = rays + 1;
        this.segments = new float[this.vertexNum * 8];
        this.mx = new float[this.vertexNum];
        this.my = new float[this.vertexNum];
        this.f = new float[this.vertexNum];
    }

    public Color getColor() {
        return this.color;
    }

    public float getDistance() {
        float dist = this.distance / RayHandler.gammaCorrectionParameter;
        return dist;
    }

    public boolean contains(float x, float y) {
        return false;
    }

    final boolean contactFilter(Fixture fixtureB) {
        Filter filterB = fixtureB.getFilterData();
        if (Light.filterA.groupIndex == filterB.groupIndex && Light.filterA.groupIndex != 0) {
            return Light.filterA.groupIndex > 0;
        }
        return (Light.filterA.maskBits & filterB.categoryBits) != 0 && (Light.filterA.categoryBits & filterB.maskBits) != 0;
    }

    public static void setContactFilter(Filter filter) {
        filterA = filter;
    }

    public static void setContactFilter(short categoryBits, short groupIndex, short maskBits) {
        filterA = new Filter();
        Light.filterA.categoryBits = categoryBits;
        Light.filterA.groupIndex = groupIndex;
        Light.filterA.maskBits = maskBits;
    }
}

