/*
 * Decompiled with CFR 0.152.
 */
package box2dLight;

import box2dLight.Light;
import box2dLight.LightMap;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import shaders.LightShader;

public class RayHandler
implements Disposable {
    boolean culling = true;
    boolean shadows = true;
    boolean blur = true;
    int blurNum = 1;
    Color ambientLight = new Color();
    World world;
    ShaderProgram lightShader;
    private final Matrix4 combined = new Matrix4();
    float x1;
    float x2;
    float y1;
    float y2;
    private LightMap lightMap;
    public final Array<Light> lightList = new Array(false, 16);
    public final Array<Light> disabledLights = new Array(false, 16);
    public int lightRenderedLastFrame = 0;
    static boolean gammaCorrection = false;
    static float gammaCorrectionParameter = 1.0f;
    public static boolean isDiffuse = false;
    static final float GAMMA_COR = 0.625f;

    public RayHandler(World world) {
        this(world, Gdx.graphics.getWidth() / 4, Gdx.graphics.getHeight() / 4);
    }

    public RayHandler(World world, int fboWidth, int fboHeigth) {
        this.world = world;
        this.lightMap = new LightMap(this, fboWidth, fboHeigth);
        this.lightShader = LightShader.createLightShader();
    }

    public void setCombinedMatrix(Matrix4 combined) {
        System.arraycopy(combined.val, 0, this.combined.val, 0, 16);
        float invWidth = combined.val[0];
        float halfViewPortWidth = 1.0f / invWidth;
        float x = -halfViewPortWidth * combined.val[12];
        this.x1 = x - halfViewPortWidth;
        this.x2 = x + halfViewPortWidth;
        float invHeight = combined.val[5];
        float halfViewPortHeight = 1.0f / invHeight;
        float y = -halfViewPortHeight * combined.val[13];
        this.y1 = y - halfViewPortHeight;
        this.y2 = y + halfViewPortHeight;
    }

    public void setCombinedMatrix(Matrix4 combined, float x, float y, float viewPortWidth, float viewPortHeight) {
        System.arraycopy(combined.val, 0, this.combined.val, 0, 16);
        float halfViewPortWidth = viewPortWidth * 0.5f;
        this.x1 = x - halfViewPortWidth;
        this.x2 = x + halfViewPortWidth;
        float halfViewPortHeight = viewPortHeight * 0.5f;
        this.y1 = y - halfViewPortHeight;
        this.y2 = y + halfViewPortHeight;
    }

    boolean intersect(float x, float y, float side) {
        return this.x1 < x + side && this.x2 > x - side && this.y1 < y + side && this.y2 > y - side;
    }

    public final void updateAndRender() {
        this.update();
        this.render();
    }

    public final void update() {
        int size = this.lightList.size;
        for (int j = 0; j < size; ++j) {
            this.lightList.get(j).update();
        }
    }

    public void render() {
        this.lightRenderedLastFrame = 0;
        Gdx.gl.glDepthMask(false);
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 1);
        this.renderWithShaders();
    }

    void renderWithShaders() {
        if (this.shadows || this.blur) {
            this.lightMap.frameBuffer.begin();
            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            Gdx.gl.glClear(16384);
        }
        this.lightShader.begin();
        this.lightShader.setUniformMatrix("u_projTrans", this.combined);
        int size = this.lightList.size;
        for (int i = 0; i < size; ++i) {
            this.lightList.get(i).render();
        }
        this.lightShader.end();
        if (this.shadows || this.blur) {
            this.lightMap.frameBuffer.end();
            this.lightMap.render();
        }
    }

    public boolean pointAtLight(float x, float y) {
        int size = this.lightList.size;
        for (int i = 0; i < size; ++i) {
            if (!this.lightList.get(i).contains(x, y)) continue;
            return true;
        }
        return false;
    }

    public boolean pointAtShadow(float x, float y) {
        int size = this.lightList.size;
        for (int i = 0; i < size; ++i) {
            if (!this.lightList.get(i).contains(x, y)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
        int i;
        for (i = 0; i < this.lightList.size; ++i) {
            this.lightList.get((int)i).lightMesh.dispose();
            this.lightList.get((int)i).softShadowMesh.dispose();
        }
        this.lightList.clear();
        for (i = 0; i < this.disabledLights.size; ++i) {
            this.disabledLights.get((int)i).lightMesh.dispose();
            this.disabledLights.get((int)i).softShadowMesh.dispose();
        }
        this.disabledLights.clear();
        if (this.lightMap != null) {
            this.lightMap.dispose();
        }
        if (this.lightShader != null) {
            this.lightShader.dispose();
        }
    }

    public void removeAll() {
        while (this.lightList.size > 0) {
            this.lightList.pop().remove();
        }
        while (this.disabledLights.size > 0) {
            this.disabledLights.pop().remove();
        }
    }

    public final void setCulling(boolean culling) {
        this.culling = culling;
    }

    public final void setBlur(boolean blur) {
        this.blur = blur;
    }

    public final void setBlurNum(int blurNum) {
        this.blurNum = blurNum;
    }

    public final void setShadows(boolean shadows) {
        this.shadows = shadows;
    }

    public final void setAmbientLight(float ambientLight) {
        if (ambientLight < 0.0f) {
            ambientLight = 0.0f;
        }
        if (ambientLight > 1.0f) {
            ambientLight = 1.0f;
        }
        this.ambientLight.a = ambientLight;
    }

    public final void setAmbientLight(float r, float g, float b, float a) {
        this.ambientLight.r = r;
        this.ambientLight.g = g;
        this.ambientLight.b = b;
        this.ambientLight.a = a;
    }

    public final void setAmbientLight(Color ambientLightColor) {
        this.ambientLight.set(ambientLightColor);
    }

    public final void setWorld(World world) {
        this.world = world;
    }

    public static boolean getGammaCorrection() {
        return gammaCorrection;
    }

    public static void setGammaCorrection(boolean gammeCorrectionWanted) {
        gammaCorrection = gammeCorrectionWanted;
        gammaCorrectionParameter = gammaCorrection ? 0.625f : 1.0f;
    }

    public static void useDiffuseLight(boolean useDiffuse) {
        isDiffuse = useDiffuse;
    }

    public void setLightMapRendering(boolean isAutomatic) {
        this.lightMap.lightMapDrawingDisabled = !isAutomatic;
    }

    public Texture getLightMapTexture() {
        return this.lightMap.frameBuffer.getColorBufferTexture();
    }

    public FrameBuffer getLightMapBuffer() {
        return this.lightMap.frameBuffer;
    }
}

