/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.ashley.core;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntityListener;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.signals.Listener;
import com.badlogic.ashley.signals.Signal;
import com.badlogic.ashley.utils.ImmutableIntMap;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.ObjectMap;
import java.util.Comparator;

public class Engine {
    private static SystemComparator comparator = new SystemComparator();
    private Array<Entity> entities = new Array();
    private Array<EntitySystem> systems = new Array();
    private ObjectMap<Class<?>, EntitySystem> systemsByClass = new ObjectMap();
    private ObjectMap<Family, IntMap<Entity>> families = new ObjectMap();
    private ObjectMap<Family, ImmutableIntMap<Entity>> immutableFamilies = new ObjectMap();
    private Array<EntityListener> listeners = new Array();
    private Array<EntityListener> removalPendingListeners = new Array();
    private boolean notifying = false;
    private final Listener<Entity> componentAdded = new Listener<Entity>(){

        @Override
        public void receive(Signal<Entity> signal, Entity object) {
            Engine.this.componentAdded(object);
        }
    };
    private final Listener<Entity> componentRemoved = new Listener<Entity>(){

        @Override
        public void receive(Signal<Entity> signal, Entity object) {
            Engine.this.componentRemoved(object);
        }
    };

    public void addEntity(Entity entity) {
        this.entities.add(entity);
        ObjectMap.Entries<Family, IntMap<Entity>> entries = this.families.entries();
        while (entries.hasNext) {
            Object entry = entries.next();
            if (!((Family)((ObjectMap.Entry)entry).key).matches(entity)) continue;
            ((IntMap)((ObjectMap.Entry)entry).value).put(entity.getIndex(), entity);
            entity.getFamilyBits().set(((Family)((ObjectMap.Entry)entry).key).getFamilyIndex());
        }
        entity.componentAdded.add(this.componentAdded);
        entity.componentRemoved.add(this.componentRemoved);
        this.notifying = true;
        for (EntityListener listener : this.listeners) {
            listener.entityAdded(entity);
        }
        this.notifying = false;
        this.removePendingListeners();
    }

    public void removeEntity(Entity entity) {
        this.entities.removeValue(entity, true);
        if (!entity.getFamilyBits().isEmpty()) {
            ObjectMap.Entries<Family, IntMap<Entity>> entries = this.families.entries();
            while (entries.hasNext) {
                Object entry = entries.next();
                if (!((Family)((ObjectMap.Entry)entry).key).matches(entity)) continue;
                ((IntMap)((ObjectMap.Entry)entry).value).remove(entity.getIndex());
                entity.getFamilyBits().clear(((Family)((ObjectMap.Entry)entry).key).getFamilyIndex());
            }
        }
        entity.componentAdded.remove(this.componentAdded);
        entity.componentRemoved.remove(this.componentRemoved);
        this.notifying = true;
        for (EntityListener listener : this.listeners) {
            listener.entityRemoved(entity);
        }
        this.notifying = false;
        this.removePendingListeners();
    }

    public void removeAllEntities() {
        while (this.entities.size > 0) {
            this.removeEntity(this.entities.first());
        }
    }

    public void addSystem(EntitySystem system) {
        Class<?> systemType = system.getClass();
        if (!this.systemsByClass.containsKey(systemType)) {
            this.systems.add(system);
            this.systemsByClass.put(systemType, system);
            system.addedToEngine(this);
            this.systems.sort(comparator);
        }
    }

    public void removeSystem(EntitySystem system) {
        if (this.systems.removeValue(system, true)) {
            this.systemsByClass.remove(system.getClass());
            system.removedFromEngine(this);
        }
    }

    public <T extends EntitySystem> T getSystem(Class<T> systemType) {
        return (T)this.systemsByClass.get(systemType);
    }

    public ImmutableIntMap<Entity> getEntitiesFor(Family family) {
        IntMap<Entity> entities = this.families.get(family, null);
        if (entities == null) {
            entities = new IntMap<Entity>();
            for (Entity e : this.entities) {
                if (!family.matches(e)) continue;
                entities.put(e.getIndex(), e);
                e.getFamilyBits().set(family.getFamilyIndex());
            }
            this.families.put(family, entities);
            this.immutableFamilies.put(family, new ImmutableIntMap(entities));
        }
        return this.immutableFamilies.get(family);
    }

    public void addEntityListener(EntityListener listener) {
        this.listeners.add(listener);
    }

    public void removeEntityListener(EntityListener listener) {
        if (this.notifying) {
            this.removalPendingListeners.add(listener);
        } else {
            this.listeners.removeValue(listener, true);
        }
    }

    private void componentAdded(Entity entity) {
        ObjectMap.Entries<Family, IntMap<Entity>> entries = this.families.entries();
        while (entries.hasNext) {
            Object entry = entries.next();
            if (entity.getFamilyBits().get(((Family)((ObjectMap.Entry)entry).key).getFamilyIndex()) || !((Family)((ObjectMap.Entry)entry).key).matches(entity)) continue;
            ((IntMap)((ObjectMap.Entry)entry).value).put(entity.getIndex(), entity);
            entity.getFamilyBits().set(((Family)((ObjectMap.Entry)entry).key).getFamilyIndex());
        }
    }

    private void componentRemoved(Entity entity) {
        ObjectMap.Entries<Family, IntMap<Entity>> entries = this.families.entries();
        while (entries.hasNext) {
            Object entry = entries.next();
            if (!entity.getFamilyBits().get(((Family)((ObjectMap.Entry)entry).key).getFamilyIndex()) || ((Family)((ObjectMap.Entry)entry).key).matches(entity)) continue;
            ((IntMap)((ObjectMap.Entry)entry).value).remove(entity.getIndex());
            entity.getFamilyBits().clear(((Family)((ObjectMap.Entry)entry).key).getFamilyIndex());
        }
    }

    private void removePendingListeners() {
        for (EntityListener listener : this.removalPendingListeners) {
            this.listeners.removeValue(listener, true);
        }
        this.removalPendingListeners.clear();
    }

    public void update(float deltaTime) {
        for (int i = 0; i < this.systems.size; ++i) {
            if (!this.systems.get(i).checkProcessing()) continue;
            this.systems.get(i).update(deltaTime);
        }
    }

    private static class SystemComparator
    implements Comparator<EntitySystem> {
        private SystemComparator() {
        }

        @Override
        public int compare(EntitySystem a, EntitySystem b) {
            return a.priority > b.priority ? 1 : (a.priority == b.priority ? 0 : -1);
        }
    }
}

