/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.ashley.core;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.ComponentType;
import com.badlogic.ashley.signals.Signal;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Bits;
import com.badlogic.gdx.utils.ObjectMap;

public class Entity {
    private static int nextIndex;
    private int index;
    private ObjectMap<Class<? extends Component>, Component> components = new ObjectMap();
    private Array<Component> componentsArray = new Array();
    private ImmutableArray<Component> immutableComponentsArray = new ImmutableArray<Component>(this.componentsArray);
    private Bits componentBits = new Bits();
    private Bits familyBits = new Bits();
    public int flags = 0;
    public Signal<Entity> componentAdded;
    public Signal<Entity> componentRemoved;

    public Entity() {
        this.index = nextIndex++;
        this.componentAdded = new Signal();
        this.componentRemoved = new Signal();
    }

    public Entity add(Component component) {
        Class<?> componentClass = component.getClass();
        for (int i = 0; i < this.componentsArray.size; ++i) {
            if (this.componentsArray.get(i).getClass() != componentClass) continue;
            this.componentsArray.removeIndex(i);
            break;
        }
        this.components.put(component.getClass(), component);
        this.componentsArray.add(component);
        this.componentBits.set(ComponentType.getIndexFor(component.getClass()));
        this.componentAdded.dispatch(this);
        return this;
    }

    public Component remove(Class<? extends Component> componentType) {
        Component removeComponent = this.components.get(componentType, null);
        if (removeComponent != null) {
            this.components.remove(componentType);
            this.componentsArray.removeValue(removeComponent, true);
            this.componentBits.clear(ComponentType.getIndexFor(componentType));
            this.componentRemoved.dispatch(this);
            this.components.remove(componentType);
        }
        return removeComponent;
    }

    public void removeAll() {
        ObjectMap.Keys<Class<? extends Component>> keys = this.components.keys();
        while (keys.hasNext()) {
            this.remove(keys.next());
            keys = this.components.keys();
        }
    }

    public <T extends Component> T getComponent(Class<T> componentType) {
        return (T)this.components.get(componentType);
    }

    public boolean hasComponent(Class<? extends Component> componentType) {
        return this.componentBits.get(ComponentType.getIndexFor(componentType));
    }

    public Bits getComponentBits() {
        return this.componentBits;
    }

    public ImmutableArray<Component> getComponents() {
        return this.immutableComponentsArray;
    }

    public Bits getFamilyBits() {
        return this.familyBits;
    }

    public int getIndex() {
        return this.index;
    }

    public int hashCode() {
        return this.index;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entity)) {
            return false;
        }
        Entity other = (Entity)obj;
        return this.index == other.index;
    }
}

