/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.ashley.core;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.ComponentType;
import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.utils.Bits;
import com.badlogic.gdx.utils.ObjectMap;

public class Family {
    private static ObjectMap<String, Family> families = new ObjectMap();
    private static int familyIndex = 0;
    private final Bits all;
    private final Bits one;
    private final Bits exclude;
    private final int index;

    private Family(Bits all, Bits any, Bits exclude) {
        this.all = all;
        this.one = any;
        this.exclude = exclude;
        this.index = familyIndex++;
    }

    public int getFamilyIndex() {
        return this.index;
    }

    public boolean matches(Entity entity) {
        Bits entityComponentBits = entity.getComponentBits();
        if (entityComponentBits.isEmpty()) {
            return false;
        }
        int i = this.all.nextSetBit(0);
        while (i >= 0) {
            if (!entityComponentBits.get(i)) {
                return false;
            }
            i = this.all.nextSetBit(i + 1);
        }
        if (!this.one.isEmpty() && !this.one.intersects(entityComponentBits)) {
            return false;
        }
        return this.exclude.isEmpty() || !this.exclude.intersects(entityComponentBits);
    }

    @SafeVarargs
    public static Family getFamilyFor(Class<? extends Component> ... componentTypes) {
        return Family.getFamilyFor(ComponentType.getBitsFor(componentTypes), new Bits(), new Bits());
    }

    public static Family getFamilyFor(Bits all, Bits one, Bits exclude) {
        String hash = Family.getFamilyHash(all, one, exclude);
        Family family = families.get(hash, null);
        if (family == null) {
            family = new Family(all, one, exclude);
            families.put(hash, family);
        }
        return family;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.all == null ? 0 : ((Object)this.all).hashCode());
        result = 31 * result + (this.one == null ? 0 : ((Object)this.one).hashCode());
        result = 31 * result + (this.exclude == null ? 0 : ((Object)this.exclude).hashCode());
        result = 31 * result + this.index;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Family)) {
            return false;
        }
        Family other = (Family)obj;
        if (this.all == null ? other.all != null : !((Object)this.all).equals(other.all)) {
            return false;
        }
        if (this.one == null ? other.one != null : !((Object)this.one).equals(other.one)) {
            return false;
        }
        if (this.exclude == null ? other.exclude != null : !((Object)this.exclude).equals(other.exclude)) {
            return false;
        }
        return this.index == other.index;
    }

    private static String getFamilyHash(Bits all, Bits one, Bits exclude) {
        StringBuilder builder = new StringBuilder();
        builder.append("all:");
        builder.append(Family.getBitsString(all));
        builder.append(",one:");
        builder.append(Family.getBitsString(one));
        builder.append(",exclude:");
        builder.append(Family.getBitsString(exclude));
        return builder.toString();
    }

    private static String getBitsString(Bits bits) {
        StringBuilder builder = new StringBuilder();
        int numBits = bits.length();
        for (int i = 0; i < numBits; ++i) {
            builder.append(bits.get(i) ? "1" : "0");
        }
        return builder.toString();
    }
}

