/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.ashley.core;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.reflect.ClassReflection;

public class PooledEngine
extends Engine {
    private EntityPool entityPool = new EntityPool();

    public Entity createEntity() {
        return (Entity)this.entityPool.obtain();
    }

    @Override
    public void removeEntity(Entity entity) {
        super.removeEntity(entity);
        if (ClassReflection.isAssignableFrom(PooledEntity.class, entity.getClass())) {
            PooledEntity pooledEntity = (PooledEntity)entity;
            this.entityPool.free(pooledEntity);
        }
    }

    public <T extends Component> T createComponent(Class<T> componentType) {
        return (T)((Component)Pools.obtain(componentType));
    }

    private class EntityPool
    extends Pool<PooledEntity> {
        private EntityPool() {
        }

        @Override
        protected PooledEntity newObject() {
            return new PooledEntity();
        }
    }

    private class PooledEntity
    extends Entity
    implements Pool.Poolable {
        private PooledEntity() {
        }

        @Override
        public Component remove(Class<? extends Component> componentType) {
            Component component = super.remove(componentType);
            Pools.free(component);
            return component;
        }

        @Override
        public void reset() {
            this.removeAll();
            this.flags = 0;
        }
    }
}

