/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.ashley.systems;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableIntMap;
import com.badlogic.gdx.utils.IntMap;

public abstract class IteratingSystem
extends EntitySystem {
    private Family family;
    private ImmutableIntMap<Entity> entities;

    public IteratingSystem(Family family) {
        this(family, 0);
    }

    public IteratingSystem(Family family, int priority) {
        super(priority);
        this.family = family;
    }

    @Override
    public void addedToEngine(Engine engine) {
        this.entities = engine.getEntitiesFor(this.family);
    }

    @Override
    public void removedFromEngine(Engine engine) {
        this.entities = null;
    }

    @Override
    public void update(float deltaTime) {
        for (IntMap.Entry<Entity> entry : this.entities) {
            this.processEntity((Entity)entry.value, deltaTime);
        }
    }

    public abstract void processEntity(Entity var1, float var2);
}

