/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.backends.lwjgl.LwjglApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl.LwjglClipboard;
import com.badlogic.gdx.backends.lwjgl.LwjglFiles;
import com.badlogic.gdx.backends.lwjgl.LwjglGraphics;
import com.badlogic.gdx.backends.lwjgl.LwjglInput;
import com.badlogic.gdx.backends.lwjgl.LwjglNativesLoader;
import com.badlogic.gdx.backends.lwjgl.LwjglNet;
import com.badlogic.gdx.backends.lwjgl.LwjglPreferences;
import com.badlogic.gdx.backends.lwjgl.audio.OpenALAudio;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Clipboard;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import java.awt.Canvas;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;

public class LwjglApplication
implements Application {
    protected final LwjglGraphics graphics;
    protected OpenALAudio audio;
    protected final LwjglFiles files;
    protected final LwjglInput input;
    protected final LwjglNet net;
    protected final ApplicationListener listener;
    protected Thread mainLoopThread;
    protected boolean running = true;
    protected final Array<Runnable> runnables = new Array();
    protected final Array<Runnable> executedRunnables = new Array();
    protected final Array<LifecycleListener> lifecycleListeners = new Array();
    protected int logLevel = 2;
    protected String preferencesdir;
    ObjectMap<String, Preferences> preferences = new ObjectMap();

    public LwjglApplication(ApplicationListener listener, String title, int width, int height) {
        this(listener, LwjglApplication.createConfig(title, width, height));
    }

    public LwjglApplication(ApplicationListener listener) {
        this(listener, null, 640, 480);
    }

    public LwjglApplication(ApplicationListener listener, LwjglApplicationConfiguration config) {
        this(listener, config, new LwjglGraphics(config));
    }

    public LwjglApplication(ApplicationListener listener, Canvas canvas) {
        this(listener, new LwjglApplicationConfiguration(), new LwjglGraphics(canvas));
    }

    public LwjglApplication(ApplicationListener listener, LwjglApplicationConfiguration config, Canvas canvas) {
        this(listener, config, new LwjglGraphics(canvas, config));
    }

    public LwjglApplication(ApplicationListener listener, LwjglApplicationConfiguration config, LwjglGraphics graphics) {
        LwjglNativesLoader.load();
        if (config.title == null) {
            config.title = listener.getClass().getSimpleName();
        }
        this.graphics = graphics;
        if (!LwjglApplicationConfiguration.disableAudio) {
            this.audio = new OpenALAudio(config.audioDeviceSimultaneousSources, config.audioDeviceBufferCount, config.audioDeviceBufferSize);
        }
        this.files = new LwjglFiles();
        this.input = new LwjglInput();
        this.net = new LwjglNet();
        this.listener = listener;
        this.preferencesdir = config.preferencesDirectory;
        Gdx.app = this;
        Gdx.graphics = graphics;
        Gdx.audio = this.audio;
        Gdx.files = this.files;
        Gdx.input = this.input;
        Gdx.net = this.net;
        this.initialize();
    }

    private static LwjglApplicationConfiguration createConfig(String title, int width, int height) {
        LwjglApplicationConfiguration config = new LwjglApplicationConfiguration();
        config.title = title;
        config.width = width;
        config.height = height;
        config.vSyncEnabled = true;
        return config;
    }

    private void initialize() {
        this.mainLoopThread = new Thread("LWJGL Application"){

            @Override
            public void run() {
                LwjglApplication.this.graphics.setVSync(LwjglApplication.this.graphics.config.vSyncEnabled);
                try {
                    LwjglApplication.this.mainLoop();
                }
                catch (Throwable t) {
                    if (LwjglApplication.this.audio != null) {
                        LwjglApplication.this.audio.dispose();
                    }
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new GdxRuntimeException(t);
                }
            }
        };
        this.mainLoopThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mainLoop() {
        Array<LifecycleListener> lifecycleListeners = this.lifecycleListeners;
        try {
            this.graphics.setupDisplay();
        }
        catch (LWJGLException e) {
            throw new GdxRuntimeException(e);
        }
        this.listener.create();
        this.graphics.resize = true;
        int lastWidth = this.graphics.getWidth();
        int lastHeight = this.graphics.getHeight();
        this.graphics.lastTime = System.nanoTime();
        boolean wasActive = true;
        while (this.running) {
            int frameRate;
            Display.processMessages();
            if (Display.isCloseRequested()) {
                this.exit();
            }
            boolean isActive = Display.isActive();
            if (wasActive && !isActive) {
                wasActive = false;
                Array<LifecycleListener> array = lifecycleListeners;
                synchronized (array) {
                    for (LifecycleListener listener : lifecycleListeners) {
                        listener.pause();
                    }
                }
                this.listener.pause();
            }
            if (!wasActive && isActive) {
                wasActive = true;
                this.listener.resume();
                Array<LifecycleListener> array = lifecycleListeners;
                synchronized (array) {
                    for (LifecycleListener listener : lifecycleListeners) {
                        listener.resume();
                    }
                }
            }
            boolean shouldRender = false;
            if (this.graphics.canvas != null) {
                int width = this.graphics.canvas.getWidth();
                int height = this.graphics.canvas.getHeight();
                if (lastWidth != width || lastHeight != height) {
                    lastWidth = width;
                    lastHeight = height;
                    Gdx.gl.glViewport(0, 0, lastWidth, lastHeight);
                    this.listener.resize(lastWidth, lastHeight);
                    shouldRender = true;
                }
            } else {
                this.graphics.config.x = Display.getX();
                this.graphics.config.y = Display.getY();
                if (this.graphics.resize || Display.wasResized() || Display.getWidth() != this.graphics.config.width || Display.getHeight() != this.graphics.config.height) {
                    this.graphics.resize = false;
                    Gdx.gl.glViewport(0, 0, Display.getWidth(), Display.getHeight());
                    this.graphics.config.width = Display.getWidth();
                    this.graphics.config.height = Display.getHeight();
                    if (this.listener != null) {
                        this.listener.resize(Display.getWidth(), Display.getHeight());
                    }
                    this.graphics.requestRendering();
                }
            }
            if (this.executeRunnables()) {
                shouldRender = true;
            }
            if (!this.running) break;
            this.input.update();
            shouldRender |= this.graphics.shouldRender();
            this.input.processEvents();
            if (this.audio != null) {
                this.audio.update();
            }
            if (!isActive && this.graphics.config.backgroundFPS == -1) {
                shouldRender = false;
            }
            int n = frameRate = isActive ? this.graphics.config.foregroundFPS : this.graphics.config.backgroundFPS;
            if (shouldRender) {
                this.graphics.updateTime();
                this.listener.render();
                Display.update(false);
            } else {
                if (frameRate == -1) {
                    frameRate = 10;
                }
                if (frameRate == 0) {
                    frameRate = this.graphics.config.backgroundFPS;
                }
                if (frameRate == 0) {
                    frameRate = 30;
                }
            }
            if (frameRate <= 0) continue;
            Display.sync(frameRate);
        }
        Array<LifecycleListener> array = lifecycleListeners;
        synchronized (array) {
            for (LifecycleListener listener : lifecycleListeners) {
                listener.pause();
                listener.dispose();
            }
        }
        this.listener.pause();
        this.listener.dispose();
        Display.destroy();
        if (this.audio != null) {
            this.audio.dispose();
        }
        if (this.graphics.config.forceExit) {
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeRunnables() {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.executedRunnables.addAll(this.runnables);
            this.runnables.clear();
        }
        if (this.executedRunnables.size == 0) {
            return false;
        }
        for (int i = 0; i < this.executedRunnables.size; ++i) {
            this.executedRunnables.get(i).run();
        }
        this.executedRunnables.clear();
        return true;
    }

    @Override
    public ApplicationListener getApplicationListener() {
        return this.listener;
    }

    @Override
    public Audio getAudio() {
        return this.audio;
    }

    @Override
    public Files getFiles() {
        return this.files;
    }

    @Override
    public LwjglGraphics getGraphics() {
        return this.graphics;
    }

    @Override
    public Input getInput() {
        return this.input;
    }

    @Override
    public Net getNet() {
        return this.net;
    }

    @Override
    public Application.ApplicationType getType() {
        return Application.ApplicationType.Desktop;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    public void stop() {
        this.running = false;
        try {
            this.mainLoopThread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public long getJavaHeap() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    @Override
    public long getNativeHeap() {
        return this.getJavaHeap();
    }

    @Override
    public Preferences getPreferences(String name) {
        if (this.preferences.containsKey(name)) {
            return this.preferences.get(name);
        }
        LwjglPreferences prefs = new LwjglPreferences(name, this.preferencesdir);
        this.preferences.put(name, prefs);
        return prefs;
    }

    @Override
    public Clipboard getClipboard() {
        return new LwjglClipboard();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postRunnable(Runnable runnable) {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.runnables.add(runnable);
            Gdx.graphics.requestRendering();
        }
    }

    @Override
    public void debug(String tag, String message) {
        if (this.logLevel >= 3) {
            System.out.println(tag + ": " + message);
        }
    }

    @Override
    public void debug(String tag, String message, Throwable exception) {
        if (this.logLevel >= 3) {
            System.out.println(tag + ": " + message);
            exception.printStackTrace(System.out);
        }
    }

    @Override
    public void log(String tag, String message) {
        if (this.logLevel >= 2) {
            System.out.println(tag + ": " + message);
        }
    }

    @Override
    public void log(String tag, String message, Throwable exception) {
        if (this.logLevel >= 2) {
            System.out.println(tag + ": " + message);
            exception.printStackTrace(System.out);
        }
    }

    @Override
    public void error(String tag, String message) {
        if (this.logLevel >= 1) {
            System.err.println(tag + ": " + message);
        }
    }

    @Override
    public void error(String tag, String message, Throwable exception) {
        if (this.logLevel >= 1) {
            System.err.println(tag + ": " + message);
            exception.printStackTrace(System.err);
        }
    }

    @Override
    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public int getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void exit() {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                LwjglApplication.this.running = false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.removeValue(listener, true);
        }
    }
}

