/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class Timer {
    static final Array<Timer> instances = new Array(1);
    static TimerThread thread;
    private static final int CANCELLED = -1;
    private static final int FOREVER = -2;
    static Timer instance;
    private final Array<Task> tasks = new Array(false, 8);

    public static Timer instance() {
        Timer.checkStatics();
        if (instance == null) {
            instance = new Timer();
        }
        return instance;
    }

    public Timer() {
        this.start();
    }

    public void postTask(Task task) {
        this.scheduleTask(task, 0.0f, 0.0f, 0);
    }

    public void scheduleTask(Task task, float delaySeconds) {
        this.scheduleTask(task, delaySeconds, 0.0f, 0);
    }

    public void scheduleTask(Task task, float delaySeconds, float intervalSeconds) {
        this.scheduleTask(task, delaySeconds, intervalSeconds, -2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTask(Task task, float delaySeconds, float intervalSeconds, int repeatCount) {
        if (task.repeatCount != -1) {
            throw new IllegalArgumentException("The same task may not be scheduled twice.");
        }
        task.executeTimeMillis = System.nanoTime() / 1000000L + (long)(delaySeconds * 1000.0f);
        task.intervalMillis = (long)(intervalSeconds * 1000.0f);
        task.repeatCount = repeatCount;
        Array<Task> array = this.tasks;
        synchronized (array) {
            this.tasks.add(task);
        }
        Timer.wake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Array<Timer> array = instances;
        synchronized (array) {
            instances.removeValue(this, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Array<Timer> array = instances;
        synchronized (array) {
            Timer.checkStatics();
            if (instances.contains(this, true)) {
                return;
            }
            instances.add(this);
            if (thread == null) {
                thread = new TimerThread();
            }
            Timer.wake();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Array<Task> array = this.tasks;
        synchronized (array) {
            int n = this.tasks.size;
            for (int i = 0; i < n; ++i) {
                this.tasks.get(i).cancel();
            }
            this.tasks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long update(long timeMillis, long waitMillis) {
        Array<Task> array = this.tasks;
        synchronized (array) {
            int n = this.tasks.size;
            for (int i = 0; i < n; ++i) {
                Task task = this.tasks.get(i);
                if (task.executeTimeMillis > timeMillis) {
                    waitMillis = Math.min(waitMillis, task.executeTimeMillis - timeMillis);
                    continue;
                }
                if (task.repeatCount != -1) {
                    if (task.repeatCount == 0) {
                        task.repeatCount = -1;
                    }
                    Gdx.app.postRunnable(task);
                }
                if (task.repeatCount == -1) {
                    this.tasks.removeIndex(i);
                    --i;
                    --n;
                    continue;
                }
                task.executeTimeMillis = timeMillis + task.intervalMillis;
                waitMillis = Math.min(waitMillis, task.intervalMillis);
                if (task.repeatCount <= 0) continue;
                --task.repeatCount;
            }
        }
        return waitMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delay(long delayMillis) {
        Array<Task> array = this.tasks;
        synchronized (array) {
            int n = this.tasks.size;
            for (int i = 0; i < n; ++i) {
                Task task = this.tasks.get(i);
                task.executeTimeMillis += delayMillis;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void wake() {
        Array<Timer> array = instances;
        synchronized (array) {
            instances.notifyAll();
        }
    }

    public static void post(Task task) {
        Timer.instance().postTask(task);
    }

    public static void schedule(Task task, float delaySeconds) {
        Timer.instance().scheduleTask(task, delaySeconds);
    }

    public static void schedule(Task task, float delaySeconds, float intervalSeconds) {
        Timer.instance().scheduleTask(task, delaySeconds, intervalSeconds);
    }

    public static void schedule(Task task, float delaySeconds, float intervalSeconds, int repeatCount) {
        Timer.instance().scheduleTask(task, delaySeconds, intervalSeconds, repeatCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkStatics() {
        Array<Timer> array = instances;
        synchronized (array) {
            if (thread != null && Timer.thread.app != Gdx.app) {
                thread = null;
                instances.clear();
                instance = null;
            }
        }
    }

    static {
        instance = new Timer();
    }

    static class TimerThread
    implements Runnable,
    LifecycleListener {
        Application app;
        private long pauseMillis;

        public TimerThread() {
            Gdx.app.addLifecycleListener(this);
            this.resume();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Array<Timer> array = instances;
                synchronized (array) {
                    if (this.app != Gdx.app) {
                        return;
                    }
                    long timeMillis = System.nanoTime() / 1000000L;
                    long waitMillis = 5000L;
                    int n = Timer.instances.size;
                    for (int i = 0; i < n; ++i) {
                        try {
                            waitMillis = instances.get(i).update(timeMillis, waitMillis);
                            continue;
                        }
                        catch (Throwable ex) {
                            throw new GdxRuntimeException("Task failed: " + instances.get(i).getClass().getName(), ex);
                        }
                    }
                    if (this.app != Gdx.app) {
                        return;
                    }
                    try {
                        if (waitMillis > 0L) {
                            instances.wait(waitMillis);
                        }
                    }
                    catch (InterruptedException ignored) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resume() {
            long delayMillis = System.nanoTime() / 1000000L - this.pauseMillis;
            Array<Timer> array = instances;
            synchronized (array) {
                int n = Timer.instances.size;
                for (int i = 0; i < n; ++i) {
                    instances.get(i).delay(delayMillis);
                }
            }
            this.app = Gdx.app;
            new Thread((Runnable)this, "Timer").start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pause() {
            this.pauseMillis = System.nanoTime() / 1000000L;
            Array<Timer> array = instances;
            synchronized (array) {
                this.app = null;
                Timer.wake();
            }
        }

        @Override
        public void dispose() {
            this.pause();
            Gdx.app.removeLifecycleListener(this);
            thread = null;
            instances.clear();
            instance = null;
        }
    }

    public static abstract class Task
    implements Runnable {
        long executeTimeMillis;
        long intervalMillis;
        int repeatCount = -1;

        @Override
        public abstract void run();

        public void cancel() {
            this.executeTimeMillis = 0L;
            this.repeatCount = -1;
        }

        public boolean isScheduled() {
            return this.repeatCount != -1;
        }

        public long getExecuteTimeMillis() {
            return this.executeTimeMillis;
        }
    }
}

