/*
 * Decompiled with CFR 0.152.
 */
package com.ethanshea.ld30;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntityListener;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.ParticleEffect;
import com.badlogic.gdx.graphics.g2d.ParticleEmitter;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.ethanshea.ld30.Player;
import com.ethanshea.ld30.component.Arrival;
import com.ethanshea.ld30.component.BulletCooldown;
import com.ethanshea.ld30.component.BulletID;
import com.ethanshea.ld30.component.Center;
import com.ethanshea.ld30.component.Destination;
import com.ethanshea.ld30.component.Direction;
import com.ethanshea.ld30.component.DoorID;
import com.ethanshea.ld30.component.FactoryCount;
import com.ethanshea.ld30.component.FactoryID;
import com.ethanshea.ld30.component.Fighting;
import com.ethanshea.ld30.component.Health;
import com.ethanshea.ld30.component.Height;
import com.ethanshea.ld30.component.Ownership;
import com.ethanshea.ld30.component.ParticleComponent;
import com.ethanshea.ld30.component.Payload;
import com.ethanshea.ld30.component.Position;
import com.ethanshea.ld30.component.Radius;
import com.ethanshea.ld30.component.Rotation;
import com.ethanshea.ld30.component.Selection;
import com.ethanshea.ld30.component.Speed;
import com.ethanshea.ld30.component.SpriteComponent;
import com.ethanshea.ld30.component.Surface;
import com.ethanshea.ld30.component.TankID;
import com.ethanshea.ld30.system.BulletMovment;
import com.ethanshea.ld30.system.CommandSystem;
import com.ethanshea.ld30.system.EnemyAI;
import com.ethanshea.ld30.system.HealthRenderer;
import com.ethanshea.ld30.system.ObjectRenderer;
import com.ethanshea.ld30.system.PlanetRenderer;
import com.ethanshea.ld30.system.RocketMovment;
import com.ethanshea.ld30.system.SecectionManager;
import com.ethanshea.ld30.system.SpaceObjectRenderer;
import com.ethanshea.ld30.system.TankAI;
import java.util.ArrayList;

public class Game
extends ApplicationAdapter
implements InputProcessor,
EntityListener {
    SpriteBatch batch;
    SpriteBatch hud;
    Engine engine;
    Family planet;
    OrthographicCamera camera;
    boolean fullscreen = false;
    static BitmapFont font;
    static Texture tankImg;
    static Texture doorImg;
    static Texture factoryImg;
    static Texture bulletImg;
    static Texture rocketImg;
    public static Sound shoot;
    public static Sound blastoff;
    public static Sound build;
    public static Sound land;
    public static Sound direct;
    public static Sound invalid;
    public static Texture storeImg;
    public static Player user;
    public static Player computer;
    static Music background;
    String msg = "";
    float accum;

    @Override
    public void create() {
        this.batch = new SpriteBatch();
        this.hud = new SpriteBatch();
        this.engine = new Engine();
        this.camera = new OrthographicCamera();
        this.camera.setToOrtho(false, 800.0f, 480.0f);
        this.camera.position.x = 0.0f;
        this.camera.position.y = 15000.0f;
        this.camera.zoom = 2.0f;
        Gdx.input.setInputProcessor(this);
        font = new BitmapFont(Gdx.files.internal("font.fnt"));
        font.setScale(1.1f, 1.5f);
        font.setColor(1.0f, 1.0f, 0.5f, 1.0f);
        tankImg = new Texture(Gdx.files.internal("tank.png"));
        doorImg = new Texture(Gdx.files.internal("door.png"));
        bulletImg = new Texture(Gdx.files.internal("bullet.png"));
        factoryImg = new Texture(Gdx.files.internal("factory.png"));
        rocketImg = new Texture(Gdx.files.internal("rocket.png"));
        storeImg = new Texture(Gdx.files.internal("store.png"));
        background = Gdx.audio.newMusic(Gdx.files.internal("emergence.ogg"));
        background.setLooping(true);
        background.setVolume(0.5f);
        background.play();
        shoot = Gdx.audio.newSound(Gdx.files.internal("shoot.wav"));
        build = Gdx.audio.newSound(Gdx.files.internal("build.wav"));
        blastoff = Gdx.audio.newSound(Gdx.files.internal("blastoff.wav"));
        land = Gdx.audio.newSound(Gdx.files.internal("land.wav"));
        direct = Gdx.audio.newSound(Gdx.files.internal("direct.wav"));
        invalid = Gdx.audio.newSound(Gdx.files.internal("invalid.wav"));
        EnemyAI ai = new EnemyAI();
        this.engine.addEntityListener(ai);
        this.engine.addEntityListener(this);
        this.engine.addSystem(new TankAI());
        this.engine.addSystem(new RocketMovment());
        this.engine.addSystem(ai);
        this.engine.addSystem(new BulletMovment());
        this.engine.addSystem(new PlanetRenderer(this.camera));
        this.engine.addSystem(new ObjectRenderer(this.camera, this.batch));
        this.engine.addSystem(new SpaceObjectRenderer(this.camera, this.batch));
        this.engine.addSystem(new HealthRenderer(this.camera));
        this.engine.addSystem(new SecectionManager(this.camera));
        this.engine.addSystem(new CommandSystem(this.camera));
        this.genLevel();
    }

    private void genLevel() {
        ArrayList<PlanetSystem> planets = new ArrayList<PlanetSystem>();
        Entity home = Game.mkPlanet(0.0f, 15000.0f, 250.0f);
        home.getComponent(Ownership.class).ownership = 1.0f;
        planets.add(new PlanetSystem(home, Game.mkDoor(135.0f, home)));
        Entity enemy = Game.mkPlanet(15000.0f, 0.0f, 250.0f);
        enemy.getComponent(Ownership.class).ownership = -1.0f;
        planets.add(new PlanetSystem(enemy, Game.mkDoor(-45.0f, enemy)));
        block0: while (planets.size() < 15) {
            float x = (float)(Math.random() * 15000.0);
            float y = (float)(Math.random() * 15000.0);
            for (PlanetSystem e : planets) {
                Position pos = e.planet.getComponent(Position.class);
                float detect = 300.0f + e.planet.getComponent(Radius.class).size;
                if (!(Game.distanceSq(pos.x, pos.y, x, y) < detect * detect)) continue;
                continue block0;
            }
            Entity p = Game.mkPlanet(x, y, 100.0f + (float)Math.random() * 300.0f);
            Entity door = Game.mkDoor(Game.randomAngle(), p);
            planets.add(new PlanetSystem(p, door));
        }
        for (PlanetSystem sys : planets) {
            Destination d = sys.door.getComponent(Destination.class);
            PlanetSystem dest = (PlanetSystem)planets.get((int)(Math.random() * 15.0));
            d.planet = dest.planet;
            d.r = Game.randomAngle();
        }
        for (PlanetSystem sys : planets) {
            this.engine.addEntity(sys.planet);
            this.engine.addEntity(sys.door);
        }
    }

    @Override
    public void render() {
        if (Gdx.input.isKeyPressed(62)) {
            return;
        }
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        if (Gdx.input.isKeyPressed(131)) {
            Gdx.app.exit();
        }
        float MOVMENT_SPEED = 15.0f;
        if (Gdx.input.isKeyPressed(19)) {
            this.camera.position.y += MOVMENT_SPEED * this.camera.zoom;
        } else if (Gdx.input.isKeyPressed(20)) {
            this.camera.position.y -= MOVMENT_SPEED * this.camera.zoom;
        }
        if (Gdx.input.isKeyPressed(22)) {
            this.camera.position.x += MOVMENT_SPEED * this.camera.zoom;
        } else if (Gdx.input.isKeyPressed(21)) {
            this.camera.position.x -= MOVMENT_SPEED * this.camera.zoom;
        }
        float scrX = (float)Gdx.input.getX() * (800.0f / (float)Gdx.graphics.getWidth());
        float scrY = (float)Gdx.input.getY() * (480.0f / (float)Gdx.graphics.getHeight());
        if (scrX < 20.0f) {
            this.camera.position.x -= MOVMENT_SPEED * this.camera.zoom;
        } else if (scrX > 790.0f) {
            this.camera.position.x += MOVMENT_SPEED * this.camera.zoom;
        }
        if (scrY < 20.0f) {
            this.camera.position.y += MOVMENT_SPEED * this.camera.zoom;
        } else if (scrY > 460.0f) {
            this.camera.position.y -= MOVMENT_SPEED * this.camera.zoom;
        }
        this.camera.position.x = MathUtils.clamp(this.camera.position.x, -1000.0f, 16000.0f);
        this.camera.position.y = MathUtils.clamp(this.camera.position.y, -1000.0f, 16000.0f);
        if (Gdx.input.isKeyJustPressed(254)) {
            boolean bl = this.fullscreen = !this.fullscreen;
            if (this.fullscreen) {
                Gdx.graphics.setDisplayMode(Gdx.graphics.getDesktopDisplayMode().width, Gdx.graphics.getDesktopDisplayMode().height, true);
            } else {
                Gdx.graphics.setDisplayMode(800, 480, false);
            }
        }
        if (Gdx.input.isKeyJustPressed(41)) {
            if (background.isPlaying()) {
                background.stop();
            } else {
                background.play();
            }
        }
        this.camera.update();
        Game.user.money += Game.user.factories;
        Game.computer.money += Game.computer.factories * 4;
        this.engine.update(Gdx.graphics.getDeltaTime());
        this.hud.begin();
        font.draw(this.hud, "$" + this.insertGroupings(Game.user.money), 0.0f, font.getCapHeight() - font.getDescent());
        BitmapFont.TextBounds bounds = font.getBounds(this.msg);
        font.draw(this.hud, this.msg, 400.0f - bounds.width / 2.0f, 240.0f + bounds.height / 2.0f);
        this.hud.end();
    }

    private String insertGroupings(int in) {
        String str = String.valueOf(in);
        int counter = 0;
        for (int i = str.length() - 1; i > 0; --i) {
            if (++counter != 3) continue;
            str = str.substring(0, i) + " " + str.substring(i, str.length());
            counter = 0;
        }
        return str;
    }

    public static Entity mkPlanet(float x, float y, float size) {
        Entity e = new Entity();
        e.add(new Position(x, y));
        e.add(new Radius(size));
        e.add(new Ownership(0.0f));
        e.add(new FactoryCount());
        return e;
    }

    public static Entity mkRocket(Entity payload, Destination d) {
        Entity e = new Entity();
        Sprite s = new Sprite(rocketImg);
        s.setOriginCenter();
        e.add(new SpriteComponent(s));
        Position p = payload.getComponent(Surface.class).surface.getComponent(Position.class);
        float angleDeg = payload.getComponent(Rotation.class).r;
        double angleRad = Math.toRadians(angleDeg);
        float size = payload.getComponent(Surface.class).surface.getComponent(Radius.class).size;
        Position begin = new Position((float)Math.cos(angleRad) * size + p.x, (float)Math.sin(angleRad) * size + p.y);
        e.add(begin);
        p = payload.getComponent(Destination.class).planet.getComponent(Position.class);
        angleDeg = payload.getComponent(Destination.class).r;
        angleRad = Math.toRadians(angleDeg);
        size = payload.getComponent(Destination.class).planet.getComponent(Radius.class).size;
        Arrival arrive = new Arrival((float)Math.cos(angleRad) * size + p.x, (float)Math.sin(angleRad) * size + p.y);
        e.add(arrive);
        float rot = (float)Math.toDegrees(Math.atan2(arrive.y - begin.y, arrive.x - begin.x));
        e.add(new Rotation(rot));
        ParticleEffect effect = new ParticleEffect();
        effect.load(Gdx.files.internal("jet.p"), Gdx.files.internal("parts"));
        ParticleEmitter.ScaledNumericValue val = effect.getEmitters().get(0).getAngle();
        val.setHighMax(rot + 20.0f + 180.0f);
        val.setHighMin(rot - 20.0f + 180.0f);
        val.setLow(rot - 20.0f + 180.0f);
        e.add(new ParticleComponent(effect));
        e.add(new Ownership(payload.getComponent(Ownership.class).ownership));
        e.add(new Speed(0.0f));
        e.add(new Payload(payload));
        e.add(payload.getComponent(Destination.class));
        return e;
    }

    public static Entity mkImmobileObj(float pos, Entity planet) {
        Entity e = new Entity();
        e.add(new Rotation(pos));
        e.add(new Surface(planet));
        float rad = (float)Math.PI / 180 * pos;
        float size = planet.getComponent(Radius.class).size;
        Position c = planet.getComponent(Position.class);
        e.add(new Center((float)(Math.cos(rad) * (double)size + (double)c.x), (float)(Math.sin(rad) * (double)size + (double)c.y)));
        return e;
    }

    public static Entity mkFactory(float pos, Entity planet, float ownership) {
        Entity e = Game.mkImmobileObj(pos, planet);
        Ownership own = new Ownership(ownership);
        e.add(own);
        Sprite s = new Sprite(factoryImg);
        s.setOrigin(16.0f, 0.0f);
        s.setColor(own.getTint());
        e.add(new SpriteComponent(s));
        e.add(new FactoryID());
        e.add(new Health(100));
        return e;
    }

    public static Entity mkDoor(float pos, Entity planet) {
        Entity e = Game.mkImmobileObj(pos, planet);
        Sprite s = new Sprite(doorImg);
        s.setOrigin(16.0f, 0.0f);
        e.add(new SpriteComponent(s));
        e.add(new Destination(0.0f, null));
        e.add(new DoorID());
        return e;
    }

    public static Entity mkMobileObj(float pos, Entity planet, boolean dir) {
        Entity e = new Entity();
        e.add(new Rotation(pos));
        e.add(new Surface(planet));
        e.add(new Direction(dir));
        return e;
    }

    public static Entity mkTank(float pos, Entity planet, float owner) {
        Entity e = Game.mkMobileObj(pos, planet, true);
        Ownership own = new Ownership(owner);
        Sprite s = new Sprite(tankImg);
        s.setOrigin(16.0f, 0.0f);
        s.setColor(own.getTint());
        e.add(new SpriteComponent(s));
        if (own.isUser()) {
            e.add(new Selection());
        }
        e.add(own);
        e.add(new Destination(pos, planet));
        e.add(new TankID());
        e.add(new Speed(0.0f));
        e.add(new BulletCooldown());
        e.add(new Health(100));
        e.add(new Fighting());
        return e;
    }

    public static Entity mkBullet(float pos, Entity planet, float owner, boolean right) {
        Entity e = Game.mkMobileObj(pos, planet, right);
        Ownership own = new Ownership(owner);
        Sprite s = new Sprite(bulletImg);
        s.setOriginCenter();
        s.setColor(own.getTint());
        e.add(new SpriteComponent(s));
        e.add(own);
        e.add(new Height(8.0f));
        e.add(new BulletID());
        return e;
    }

    public static float distanceSq(float x1, float y1, float x2, float y2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
    }

    @Override
    public void dispose() {
        this.batch.dispose();
        background.dispose();
    }

    @Override
    public boolean keyDown(int keycode) {
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    @Override
    public boolean scrolled(int amount) {
        this.camera.zoom = (float)((double)this.camera.zoom * Math.pow(2.0, amount));
        if (this.camera.zoom < 0.0625f) {
            this.camera.zoom = 0.0625f;
        }
        if (this.camera.zoom > 32.0f) {
            this.camera.zoom = 32.0f;
        }
        return true;
    }

    @Override
    public void entityAdded(Entity entity) {
        this.editCount(entity, 1);
    }

    @Override
    public void entityRemoved(Entity entity) {
        this.editCount(entity, -1);
    }

    public void editCount(Entity entity, int dir) {
        if (!entity.hasComponent(Ownership.class)) {
            return;
        }
        if (entity.hasComponent(FactoryID.class)) {
            String m;
            Player p;
            entity.getComponent(Surface.class).surface.getComponent(FactoryCount.class).count += dir;
            Ownership own = entity.getComponent(Ownership.class);
            if (own.isEnemy()) {
                p = computer;
                m = "You win!";
            } else if (own.isUser()) {
                p = user;
                m = "You lose.";
            } else {
                return;
            }
            p.factories += dir;
            if (p.factories == 0 && p.money < 5000) {
                this.msg = m;
            }
        }
    }

    public static float randomAngle() {
        return (float)(Math.random() * 360.0 - 180.0);
    }

    static {
        user = new Player();
        computer = new Player();
    }

    private class PlanetSystem {
        public Entity planet;
        public Entity door;

        public PlanetSystem(Entity planet, Entity door) {
            this.planet = planet;
            this.door = door;
        }
    }
}

