/*
 * Decompiled with CFR 0.152.
 */
package com.ethanshea.ld30.system;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.systems.IteratingSystem;
import com.badlogic.gdx.utils.IntMap;
import com.ethanshea.ld30.component.BulletID;
import com.ethanshea.ld30.component.Direction;
import com.ethanshea.ld30.component.Health;
import com.ethanshea.ld30.component.Height;
import com.ethanshea.ld30.component.Ownership;
import com.ethanshea.ld30.component.Radius;
import com.ethanshea.ld30.component.Rotation;
import com.ethanshea.ld30.component.Surface;

public class BulletMovment
extends IteratingSystem {
    final Family target = Family.getFamilyFor(Health.class, Surface.class, Rotation.class, Ownership.class);
    Engine engine;

    public BulletMovment() {
        super(Family.getFamilyFor(BulletID.class, Rotation.class, Height.class, Surface.class));
    }

    @Override
    public void addedToEngine(Engine engine) {
        super.addedToEngine(engine);
        this.engine = engine;
    }

    @Override
    public void processEntity(Entity entity, float deltaTime) {
        Rotation rot = entity.getComponent(Rotation.class);
        rot.r += 200.0f * entity.getComponent(Direction.class).asFloat() / entity.getComponent(Surface.class).surface.getComponent(Radius.class).size;
        if (rot.r < -180.0f) {
            rot.r += 360.0f;
        }
        if (rot.r > 180.0f) {
            rot.r -= 360.0f;
        }
        Height height = entity.getComponent(Height.class);
        height.height -= 0.035f;
        if (height.height < 0.0f) {
            this.engine.removeEntity(entity);
            return;
        }
        Entity planet = entity.getComponent(Surface.class).surface;
        Ownership own = entity.getComponent(Ownership.class);
        for (IntMap.Entry<Entity> entry : this.engine.getEntitiesFor(this.target)) {
            if (!((Entity)entry.value).getComponent(Surface.class).surface.equals(planet) || !((Entity)entry.value).getComponent(Ownership.class).isEnemyOf(own) || !(Math.abs(((Entity)entry.value).getComponent(Rotation.class).r - rot.r) < 3.0f)) continue;
            Health h = ((Entity)entry.value).getComponent(Health.class);
            h.health = (int)((float)h.health - height.height * 6.0f);
            if (h.health <= 0) {
                this.engine.removeEntity((Entity)entry.value);
            }
            this.engine.removeEntity(entity);
        }
    }
}

