/*
 * Decompiled with CFR 0.152.
 */
package com.ethanshea.ld30.system;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.systems.IteratingSystem;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.IntMap;
import com.ethanshea.ld30.Game;
import com.ethanshea.ld30.component.Center;
import com.ethanshea.ld30.component.Destination;
import com.ethanshea.ld30.component.Direction;
import com.ethanshea.ld30.component.FactoryCount;
import com.ethanshea.ld30.component.FactoryID;
import com.ethanshea.ld30.component.Ownership;
import com.ethanshea.ld30.component.Position;
import com.ethanshea.ld30.component.Radius;
import com.ethanshea.ld30.component.Rotation;
import com.ethanshea.ld30.component.Selection;
import com.ethanshea.ld30.component.Surface;

public class CommandSystem
extends IteratingSystem {
    int buildSelect;
    Engine engine;
    Family planet = Family.getFamilyFor(Position.class, Radius.class);
    Family factory = Family.getFamilyFor(Rotation.class, Surface.class, Ownership.class, Center.class, FactoryID.class);
    Camera cam;
    Entity currentPlanet;
    float currentAngle;
    ShapeRenderer render = new ShapeRenderer();
    ShapeRenderer hud = new ShapeRenderer();
    SpriteBatch batch = new SpriteBatch();
    int orderNum;

    public CommandSystem(Camera cam) {
        super(Family.getFamilyFor(Surface.class, Rotation.class, Selection.class, Destination.class, Direction.class));
        this.cam = cam;
        this.hud = this.hud;
    }

    @Override
    public void addedToEngine(Engine engine) {
        super.addedToEngine(engine);
        this.engine = engine;
    }

    @Override
    public void update(float delta) {
        this.currentPlanet = null;
        this.orderNum = 0;
        Vector3 pos = this.cam.unproject(new Vector3(Gdx.input.getX(), Gdx.input.getY(), 0.0f));
        for (IntMap.Entry<Entity> entry : this.engine.getEntitiesFor(this.planet)) {
            Position center = ((Entity)entry.value).getComponent(Position.class);
            float f = 50.0f;
            float detect = 50.0f + ((Entity)entry.value).getComponent(Radius.class).size;
            if (!(Game.distanceSq(pos.x, pos.y, center.x, center.y) < detect * detect)) continue;
            double angleRad = Math.atan2(pos.y - center.y, pos.x - center.x);
            this.currentPlanet = (Entity)entry.value;
            this.currentAngle = (float)(57.29577951308232 * angleRad);
            Gdx.gl.glLineWidth(2.0f);
            this.render.setProjectionMatrix(this.cam.combined);
            this.render.begin(ShapeRenderer.ShapeType.Line);
            this.render.setColor(0.8f, 1.0f, 0.2f, 0.5f);
            this.render.line(center.x, center.y, (float)Math.cos(angleRad) * detect + center.x, (float)Math.sin(angleRad) * detect + center.y);
            this.render.end();
            Gdx.gl.glLineWidth(1.0f);
            break;
        }
        this.batch.begin();
        this.batch.draw(Game.storeImg, 736.0f, 352.0f);
        this.batch.end();
        Gdx.gl.glLineWidth(2.0f);
        this.hud.begin(ShapeRenderer.ShapeType.Line);
        this.hud.setColor(0.8f, 1.0f, 0.2f, 0.5f);
        this.hud.rect(740.0f, this.buildSelect * -64 + 4 + 480 - 64, 60.0f, 60.0f);
        this.hud.end();
        Gdx.gl.glLineWidth(1.0f);
        float scrX = (float)Gdx.input.getX() * (800.0f / (float)Gdx.graphics.getWidth());
        float f = (float)Gdx.input.getY() * (480.0f / (float)Gdx.graphics.getHeight());
        if (scrX > 736.0f && f < 128.0f && Gdx.input.isButtonPressed(0)) {
            this.buildSelect = (int)(f / 64.0f);
        } else {
            super.update(delta);
            if (Gdx.input.justTouched() && Gdx.input.isButtonPressed(0)) {
                if (this.currentPlanet != null) {
                    if (this.buildSelect == 1) {
                        if (this.currentPlanet.getComponent(Ownership.class).ownership > 0.5f && Game.user.money > 5000 && this.currentPlanet.getComponent(FactoryCount.class).count < 5) {
                            this.engine.addEntity(Game.mkFactory(this.currentAngle, this.currentPlanet, 1.0f));
                            Game.user.money -= 5000;
                            Game.build.play();
                            return;
                        }
                        Game.invalid.play();
                    }
                    if (this.buildSelect == 0) {
                        if (Game.user.money > 2000) {
                            for (IntMap.Entry<Entity> entry : this.engine.getEntitiesFor(this.factory)) {
                                Center c = ((Entity)entry.value).getComponent(Center.class);
                                if (!(Game.distanceSq(c.x, c.y, pos.x, pos.y) < 900.0f)) continue;
                                this.engine.addEntity(Game.mkTank(this.currentAngle, this.currentPlanet, Gdx.input.isKeyPressed(29) ? -1.0f : 1.0f));
                                Game.user.money -= 2000;
                                Game.build.play();
                                return;
                            }
                        }
                        Game.invalid.play();
                    }
                }
                this.buildSelect = -1;
            }
        }
    }

    @Override
    public void processEntity(Entity entity, float deltaTime) {
        Destination d = entity.getComponent(Destination.class);
        if (this.currentPlanet != null && Gdx.input.isButtonPressed(1) && Gdx.input.justTouched() && entity.getComponent(Selection.class).selected) {
            d.planet = this.currentPlanet;
            d.r = this.currentAngle + entity.getComponent(Direction.class).asFloat() * -5.0f * (float)this.orderNum;
            d.arrived = false;
            if (this.orderNum == 0) {
                Game.direct.play();
            }
            ++this.orderNum;
        }
    }
}

