/*
 * Decompiled with CFR 0.152.
 */
package com.ethanshea.ld30.system;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntityListener;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.utils.IntMap;
import com.ethanshea.ld30.Game;
import com.ethanshea.ld30.component.Destination;
import com.ethanshea.ld30.component.FactoryCount;
import com.ethanshea.ld30.component.FactoryID;
import com.ethanshea.ld30.component.Fighting;
import com.ethanshea.ld30.component.Ownership;
import com.ethanshea.ld30.component.Payload;
import com.ethanshea.ld30.component.Position;
import com.ethanshea.ld30.component.Radius;
import com.ethanshea.ld30.component.Rotation;
import com.ethanshea.ld30.component.Surface;
import com.ethanshea.ld30.component.TankID;
import java.util.ArrayList;

public class EnemyAI
extends EntitySystem
implements EntityListener {
    private static final Family planetFamily = Family.getFamilyFor(Position.class, Ownership.class, Radius.class);
    private static final Family factoryFamily = Family.getFamilyFor(FactoryID.class);
    private static final Family tankFamily = Family.getFamilyFor(TankID.class, Fighting.class, Destination.class, Ownership.class);
    public int counter;
    public int factoryCount;
    public int tankCount;
    public Engine engine;
    public final float tankFactoryRatio = 1.25f;

    @Override
    public void addedToEngine(Engine engine) {
        super.addedToEngine(engine);
        this.engine = engine;
    }

    @Override
    public void update(float deltaTime) {
        ++this.counter;
        if (this.counter % 10 != 0) {
            return;
        }
        if ((float)this.tankCount / (float)this.factoryCount > 1.25f || this.factoryCount == 0) {
            if (Game.computer.money > 5000) {
                Entity planet = this.randomControlledPlanet();
                if (planet == null) {
                    return;
                }
                if (planet.getComponent(FactoryCount.class).count < 5) {
                    this.engine.addEntity(Game.mkFactory(Game.randomAngle(), planet, -1.0f));
                    ++planet.getComponent(FactoryCount.class).count;
                    Game.computer.money -= 5000;
                }
            }
        } else if (Game.computer.money > 2000) {
            Entity factory = this.randomControlledFactory();
            if (factory == null) {
                return;
            }
            Entity entity = Game.mkTank(factory.getComponent(Rotation.class).r, factory.getComponent(Surface.class).surface, -1.0f);
            this.engine.addEntity(entity);
            Game.computer.money -= 5000;
        }
        for (IntMap.Entry<Entity> entry : this.engine.getEntitiesFor(tankFamily)) {
            Entity planet;
            if (!((Entity)entry.value).getComponent(Ownership.class).isEnemy()) continue;
            Destination d = ((Entity)entry.value).getComponent(Destination.class);
            if (((Entity)entry.value).getComponent(Fighting.class).fighting) {
                d.r = ((Entity)entry.value).getComponent(Fighting.class).target.getComponent(Rotation.class).r;
                d.arrived = false;
                continue;
            }
            if (Math.random() < (double)0.05f && (planet = this.randomUserControlledPlanet()) != null) {
                d.r = Game.randomAngle();
                d.planet = planet;
                d.arrived = false;
                continue;
            }
            if (!d.arrived) continue;
            d.r = Game.randomAngle();
            d.planet = ((Entity)entry.value).getComponent(Surface.class).surface;
            d.arrived = false;
        }
    }

    public Entity randomControlledPlanet() {
        ArrayList matches = new ArrayList();
        for (IntMap.Entry<Entity> entry : this.engine.getEntitiesFor(planetFamily)) {
            if (!((Entity)entry.value).getComponent(Ownership.class).isEnemy()) continue;
            matches.add(entry.value);
        }
        if (matches.size() == 0) {
            return null;
        }
        return (Entity)matches.get((int)(Math.random() * (double)matches.size()));
    }

    public Entity randomUserControlledPlanet() {
        ArrayList matches = new ArrayList();
        for (IntMap.Entry<Entity> entry : this.engine.getEntitiesFor(planetFamily)) {
            if (!((Entity)entry.value).getComponent(Ownership.class).isUser()) continue;
            matches.add(entry.value);
        }
        if (matches.size() == 0) {
            return null;
        }
        return (Entity)matches.get((int)(Math.random() * (double)matches.size()));
    }

    public Entity randomControlledFactory() {
        ArrayList matches = new ArrayList();
        for (IntMap.Entry<Entity> entry : this.engine.getEntitiesFor(factoryFamily)) {
            if (!((Entity)entry.value).getComponent(Ownership.class).isEnemy()) continue;
            matches.add(entry.value);
        }
        if (matches.size() == 0) {
            return null;
        }
        return (Entity)matches.get((int)(Math.random() * (double)matches.size()));
    }

    @Override
    public void entityAdded(Entity entity) {
        this.editCount(entity, 1);
    }

    @Override
    public void entityRemoved(Entity entity) {
        this.editCount(entity, -1);
    }

    public void editCount(Entity entity, int dir) {
        if (!entity.hasComponent(Ownership.class)) {
            return;
        }
        if (!entity.getComponent(Ownership.class).isEnemy()) {
            return;
        }
        if (entity.hasComponent(Payload.class)) {
            return;
        }
        if (entity.hasComponent(TankID.class)) {
            this.tankCount += dir;
            return;
        }
        if (entity.hasComponent(FactoryID.class)) {
            this.factoryCount += dir;
            return;
        }
    }
}

