/*
 * Decompiled with CFR 0.152.
 */
package com.ethanshea.ld30.system;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.systems.IteratingSystem;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.ethanshea.ld30.component.Health;
import com.ethanshea.ld30.component.Position;
import com.ethanshea.ld30.component.Radius;
import com.ethanshea.ld30.component.Rotation;
import com.ethanshea.ld30.component.Surface;

public class HealthRenderer
extends IteratingSystem {
    Camera cam;
    ShapeRenderer render = new ShapeRenderer();

    public HealthRenderer(Camera cam) {
        super(Family.getFamilyFor(Health.class, Surface.class, Rotation.class));
        this.cam = cam;
    }

    @Override
    public void update(float delta) {
        this.render.setProjectionMatrix(this.cam.combined);
        super.update(delta);
    }

    @Override
    public void processEntity(Entity entity, float deltaTime) {
        Health health = entity.getComponent(Health.class);
        if (health.health == health.max) {
            return;
        }
        Position c = entity.getComponent(Surface.class).surface.getComponent(Position.class);
        this.render.begin(ShapeRenderer.ShapeType.Filled);
        this.render.identity();
        this.render.translate(c.x, c.y, 0.0f);
        this.render.rotate(0.0f, 0.0f, 1.0f, entity.getComponent(Rotation.class).r);
        float percent = (float)health.health / (float)health.max;
        this.render.setColor(1.0f - (percent *= 0.8f), percent, 0.3f, 1.0f);
        this.render.rect(entity.getComponent(Surface.class).surface.getComponent(Radius.class).size - 8.0f, -20.0f, 3.0f, 40.0f);
        this.render.end();
    }
}

