/*
 * Decompiled with CFR 0.152.
 */
package com.ethanshea.ld30.system;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.systems.IteratingSystem;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.ethanshea.ld30.component.Ownership;
import com.ethanshea.ld30.component.Position;
import com.ethanshea.ld30.component.Radius;

public class PlanetRenderer
extends IteratingSystem {
    private ShapeRenderer renderer = new ShapeRenderer();
    private Camera cam;

    public PlanetRenderer(Camera cam) {
        super(Family.getFamilyFor(Position.class, Radius.class, Ownership.class));
        this.cam = cam;
    }

    @Override
    public void processEntity(Entity entity, float deltaTime) {
        this.renderer.setProjectionMatrix(this.cam.combined);
        this.renderer.begin(ShapeRenderer.ShapeType.Filled);
        this.renderer.setColor(entity.getComponent(Ownership.class).getColor());
        Position pos = entity.getComponent(Position.class);
        this.renderer.circle(pos.x, pos.y, entity.getComponent(Radius.class).size);
        this.renderer.end();
    }
}

