/*
 * Decompiled with CFR 0.152.
 */
package com.ethanshea.ld30.system;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.systems.IteratingSystem;
import com.ethanshea.ld30.Game;
import com.ethanshea.ld30.component.Arrival;
import com.ethanshea.ld30.component.Destination;
import com.ethanshea.ld30.component.ParticleComponent;
import com.ethanshea.ld30.component.Payload;
import com.ethanshea.ld30.component.Position;
import com.ethanshea.ld30.component.Rotation;
import com.ethanshea.ld30.component.Speed;
import com.ethanshea.ld30.component.Surface;

public class RocketMovment
extends IteratingSystem {
    private Engine engine;

    public RocketMovment() {
        super(Family.getFamilyFor(Arrival.class, Position.class, Speed.class, Rotation.class, Destination.class));
    }

    @Override
    public void addedToEngine(Engine engine) {
        super.addedToEngine(engine);
        this.engine = engine;
    }

    @Override
    public void processEntity(Entity entity, float deltaTime) {
        double angleRad = Math.toRadians(entity.getComponent(Rotation.class).r);
        Speed speed = entity.getComponent(Speed.class);
        speed.speed += 0.0015f;
        double velX = Math.cos(angleRad) * (double)speed.speed;
        double velY = Math.sin(angleRad) * (double)speed.speed;
        Position pos = entity.getComponent(Position.class);
        pos.x = (float)((double)pos.x + velX);
        pos.y = (float)((double)pos.y + velY);
        Position dest = entity.getComponent(Arrival.class);
        if (Game.distanceSq(pos.x, pos.y, dest.x, dest.y) < speed.speed * speed.speed * 40.0f) {
            Game.land.play();
            Entity payload = entity.getComponent(Payload.class).load;
            payload.getComponent(Surface.class).surface = entity.getComponent(Destination.class).planet;
            payload.getComponent(Rotation.class).r = entity.getComponent(Destination.class).r;
            payload.add(entity.getComponent(Destination.class));
            entity.getComponent(ParticleComponent.class).effect.dispose();
            this.engine.addEntity(payload);
            this.engine.removeEntity(entity);
        }
    }
}

