/*
 * Decompiled with CFR 0.152.
 */
package com.ethanshea.ld30.system;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.systems.IteratingSystem;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.ethanshea.ld30.component.Position;
import com.ethanshea.ld30.component.Radius;
import com.ethanshea.ld30.component.Rotation;
import com.ethanshea.ld30.component.Selection;
import com.ethanshea.ld30.component.Surface;

public class SecectionManager
extends IteratingSystem {
    Position start = new Position(0.0f, 0.0f);
    Position end = new Position(0.0f, 0.0f);
    Rectangle box = new Rectangle();
    Camera cam;
    ShapeRenderer render = new ShapeRenderer();

    public SecectionManager(Camera cam) {
        super(Family.getFamilyFor(Selection.class, Rotation.class, Surface.class));
        this.cam = cam;
    }

    @Override
    public void update(float delta) {
        this.render.setProjectionMatrix(this.cam.combined);
        this.render.begin(ShapeRenderer.ShapeType.Line);
        this.render.setColor(0.1f, 0.8f, 0.1f, 1.0f);
        if (Gdx.input.isButtonPressed(0)) {
            Vector3 pos = this.cam.unproject(new Vector3(Gdx.input.getX(), Gdx.input.getY(), 0.0f));
            if (Gdx.input.justTouched()) {
                this.start.x = pos.x;
                this.start.y = pos.y;
            }
            this.end.x = pos.x;
            this.end.y = pos.y;
            this.box.set(Math.min(this.start.x, this.end.x), Math.min(this.start.y, this.end.y), Math.abs(this.end.x - this.start.x), Math.abs(this.end.y - this.start.y));
            this.render.rect(this.box.x, this.box.y, this.box.width, this.box.height);
        }
        super.update(delta);
        this.render.end();
    }

    @Override
    public void processEntity(Entity entity, float deltaTime) {
        Selection select = entity.getComponent(Selection.class);
        if (!select.selected && !Gdx.input.isButtonPressed(0)) {
            return;
        }
        float rad = (float)Math.PI / 180 * entity.getComponent(Rotation.class).r;
        float sx = (float)Math.cos(rad);
        float sy = (float)Math.sin(rad);
        Entity surface = entity.getComponent(Surface.class).surface;
        float size = surface.getComponent(Radius.class).size;
        Position c = surface.getComponent(Position.class);
        Position pos = new Position(sx * (size + 8.0f) + c.x, sy * (size + 8.0f) + c.y);
        if (Gdx.input.isButtonPressed(0)) {
            select.selected = this.box.contains(pos.x, pos.y);
        }
        if (select.selected) {
            this.render.rect(pos.x - 20.0f, pos.y - 20.0f, 40.0f, 40.0f);
        }
    }
}

