/*
 * Decompiled with CFR 0.152.
 */
package com.ethanshea.ld30.system;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.systems.IteratingSystem;
import com.badlogic.gdx.utils.IntMap;
import com.ethanshea.ld30.Game;
import com.ethanshea.ld30.component.BulletCooldown;
import com.ethanshea.ld30.component.Destination;
import com.ethanshea.ld30.component.Direction;
import com.ethanshea.ld30.component.DoorID;
import com.ethanshea.ld30.component.Fighting;
import com.ethanshea.ld30.component.Ownership;
import com.ethanshea.ld30.component.Position;
import com.ethanshea.ld30.component.Radius;
import com.ethanshea.ld30.component.Rotation;
import com.ethanshea.ld30.component.Selection;
import com.ethanshea.ld30.component.Speed;
import com.ethanshea.ld30.component.Surface;
import com.ethanshea.ld30.component.TankID;

public class TankAI
extends IteratingSystem {
    Family surfaceObj = Family.getFamilyFor(Rotation.class, Surface.class);
    private Engine engine;

    public TankAI() {
        super(Family.getFamilyFor(Surface.class, Rotation.class, Destination.class, Speed.class, Direction.class, TankID.class, Fighting.class));
    }

    @Override
    public void addedToEngine(Engine engine) {
        super.addedToEngine(engine);
        this.engine = engine;
    }

    @Override
    public void processEntity(Entity entity, float deltaTime) {
        Ownership own = entity.getComponent(Ownership.class);
        Rotation rot = entity.getComponent(Rotation.class);
        Direction direction = entity.getComponent(Direction.class);
        Destination d = entity.getComponent(Destination.class);
        if (d.planet.equals(entity.getComponent(Surface.class).surface)) {
            this.moveTowards(entity, d.r);
        } else {
            Position from = entity.getComponent(Surface.class).surface.getComponent(Position.class);
            Position to = d.planet.getComponent(Position.class);
            if (this.moveTowards(entity, (float)Math.toDegrees(Math.atan2(to.y - from.y, to.x - from.x)))) {
                Game.blastoff.play(own.isUser() ? 1.0f : 0.5f);
                if (entity.hasComponent(Selection.class)) {
                    entity.getComponent(Selection.class).selected = false;
                }
                this.engine.removeEntity(entity);
                this.engine.addEntity(Game.mkRocket(entity, d));
            }
        }
        BulletCooldown cool = entity.getComponent(BulletCooldown.class);
        --cool.cooldown;
        Entity planet = entity.getComponent(Surface.class).surface;
        Fighting fight = entity.getComponent(Fighting.class);
        boolean fighting = false;
        for (IntMap.Entry<Entity> entry : this.engine.getEntitiesFor(this.surfaceObj)) {
            if (entry == null || entry.value == null || ((Entity)entry.value).getComponent(Surface.class) == null || ((Entity)entry.value).getComponent(Surface.class).surface == null || !((Entity)entry.value).getComponent(Surface.class).surface.equals(planet)) continue;
            if (Math.abs(((Entity)entry.value).getComponent(Rotation.class).r - rot.r) < 2.0f && ((Entity)entry.value).hasComponent(DoorID.class)) {
                Destination dest = ((Entity)entry.value).getComponent(Destination.class);
                rot.r = dest.r;
                d.r = dest.r;
                d.planet = dest.planet;
                entity.getComponent(Surface.class).surface = dest.planet;
            }
            if (!((Entity)entry.value).hasComponent(Ownership.class) || !own.isEnemyOf(((Entity)entry.value).getComponent(Ownership.class)) || !(((Entity)entry.value).getComponent(Rotation.class).r - rot.r + 0.0f < 135.0f)) continue;
            fighting = true;
            fight.target = (Entity)entry.value;
            if (cool.cooldown >= 0) continue;
            this.engine.addEntity(Game.mkBullet(rot.r, planet, own.ownership, direction.right));
            Game.shoot.play();
            cool.cooldown = 300;
        }
        fight.fighting = fighting;
        Ownership planetOwner = entity.getComponent(Surface.class).surface.getComponent(Ownership.class);
        planetOwner.ownership += own.ownership * 0.001f;
        if (Math.abs(planetOwner.ownership) > 1.0f) {
            planetOwner.ownership = own.ownership;
        }
    }

    private boolean moveTowards(Entity entity, float dest) {
        Rotation rot = entity.getComponent(Rotation.class);
        Speed spd = entity.getComponent(Speed.class);
        Direction direction = entity.getComponent(Direction.class);
        Destination destination = entity.getComponent(Destination.class);
        if (Math.abs(rot.r - dest) > 2.0f) {
            float diff = dest - rot.r;
            int dir = diff <= -180.0f || diff > 0.0f && diff <= 180.0f ? 1 : -1;
            direction.right = dir < 0;
            float inc = 1.0f / entity.getComponent(Surface.class).surface.getComponent(Radius.class).size;
            spd.speed += inc * (float)dir;
            if (Math.abs(spd.speed) > inc * 60.0f) {
                spd.speed = inc * 60.0f * (float)dir;
            }
            rot.r += spd.speed;
            if (rot.r < -180.0f) {
                rot.r += 360.0f;
            }
            if (rot.r > 180.0f) {
                rot.r -= 360.0f;
            }
            destination.arrived = false;
            return false;
        }
        spd.speed = 0.0f;
        destination.arrived = true;
        return true;
    }
}

